/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.SqlConnectionInfo;
import java.io.IOException;
import java.util.List;

public final class GetUserTablesSqlTaskInput
implements JsonSerializable<GetUserTablesSqlTaskInput> {
    private SqlConnectionInfo connectionInfo;
    private List<String> selectedDatabases;
    private String encryptedKeyForSecureFields;
    private static final ClientLogger LOGGER = new ClientLogger(GetUserTablesSqlTaskInput.class);

    public SqlConnectionInfo connectionInfo() {
        return this.connectionInfo;
    }

    public GetUserTablesSqlTaskInput withConnectionInfo(SqlConnectionInfo connectionInfo) {
        this.connectionInfo = connectionInfo;
        return this;
    }

    public List<String> selectedDatabases() {
        return this.selectedDatabases;
    }

    public GetUserTablesSqlTaskInput withSelectedDatabases(List<String> selectedDatabases) {
        this.selectedDatabases = selectedDatabases;
        return this;
    }

    public String encryptedKeyForSecureFields() {
        return this.encryptedKeyForSecureFields;
    }

    public GetUserTablesSqlTaskInput withEncryptedKeyForSecureFields(String encryptedKeyForSecureFields) {
        this.encryptedKeyForSecureFields = encryptedKeyForSecureFields;
        return this;
    }

    public void validate() {
        if (this.connectionInfo() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property connectionInfo in model GetUserTablesSqlTaskInput"));
        }
        this.connectionInfo().validate();
        if (this.selectedDatabases() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property selectedDatabases in model GetUserTablesSqlTaskInput"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionInfo", (JsonSerializable)this.connectionInfo);
        jsonWriter.writeArrayField("selectedDatabases", this.selectedDatabases, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("encryptedKeyForSecureFields", this.encryptedKeyForSecureFields);
        return jsonWriter.writeEndObject();
    }

    public static GetUserTablesSqlTaskInput fromJson(JsonReader jsonReader) throws IOException {
        return (GetUserTablesSqlTaskInput)jsonReader.readObject(reader -> {
            GetUserTablesSqlTaskInput deserializedGetUserTablesSqlTaskInput = new GetUserTablesSqlTaskInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionInfo".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskInput.connectionInfo = SqlConnectionInfo.fromJson(reader);
                    continue;
                }
                if ("selectedDatabases".equals(fieldName)) {
                    List selectedDatabases;
                    deserializedGetUserTablesSqlTaskInput.selectedDatabases = selectedDatabases = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("encryptedKeyForSecureFields".equals(fieldName)) {
                    deserializedGetUserTablesSqlTaskInput.encryptedKeyForSecureFields = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGetUserTablesSqlTaskInput;
        });
    }
}

