/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.http.rest.Response;
import com.azure.core.management.Region;
import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.fluent.models.DataMigrationServiceInner;
import com.azure.resourcemanager.datamigration.models.DataMigrationServiceStatusResponse;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityRequest;
import com.azure.resourcemanager.datamigration.models.NameAvailabilityResponse;
import com.azure.resourcemanager.datamigration.models.ServiceProvisioningState;
import com.azure.resourcemanager.datamigration.models.ServiceSku;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.util.Map;

public interface DataMigrationService {
    public String id();

    public String name();

    public String type();

    public String location();

    public Map<String, String> tags();

    public String etag();

    public String kind();

    public ServiceSku sku();

    public SystemDataAutoGenerated systemData();

    public ServiceProvisioningState provisioningState();

    public String publicKey();

    public String virtualSubnetId();

    public String virtualNicId();

    public String autoStopDelay();

    public Boolean deleteResourcesOnStop();

    public Region region();

    public String regionName();

    public String resourceGroupName();

    public DataMigrationServiceInner innerModel();

    public Update update();

    public DataMigrationService refresh();

    public DataMigrationService refresh(Context var1);

    public Response<DataMigrationServiceStatusResponse> checkStatusWithResponse(Context var1);

    public DataMigrationServiceStatusResponse checkStatus();

    public void start();

    public void start(Context var1);

    public void stop();

    public void stop(Context var1);

    public Response<NameAvailabilityResponse> checkChildrenNameAvailabilityWithResponse(NameAvailabilityRequest var1, Context var2);

    public NameAvailabilityResponse checkChildrenNameAvailability(NameAvailabilityRequest var1);

    public static interface UpdateStages {

        public static interface WithDeleteResourcesOnStop {
            public Update withDeleteResourcesOnStop(Boolean var1);
        }

        public static interface WithAutoStopDelay {
            public Update withAutoStopDelay(String var1);
        }

        public static interface WithVirtualNicId {
            public Update withVirtualNicId(String var1);
        }

        public static interface WithVirtualSubnetId {
            public Update withVirtualSubnetId(String var1);
        }

        public static interface WithPublicKey {
            public Update withPublicKey(String var1);
        }

        public static interface WithSku {
            public Update withSku(ServiceSku var1);
        }

        public static interface WithKind {
            public Update withKind(String var1);
        }

        public static interface WithEtag {
            public Update withEtag(String var1);
        }

        public static interface WithTags {
            public Update withTags(Map<String, String> var1);
        }
    }

    public static interface Update
    extends UpdateStages.WithTags,
    UpdateStages.WithEtag,
    UpdateStages.WithKind,
    UpdateStages.WithSku,
    UpdateStages.WithPublicKey,
    UpdateStages.WithVirtualSubnetId,
    UpdateStages.WithVirtualNicId,
    UpdateStages.WithAutoStopDelay,
    UpdateStages.WithDeleteResourcesOnStop {
        public DataMigrationService apply();

        public DataMigrationService apply(Context var1);
    }

    public static interface DefinitionStages {

        public static interface WithDeleteResourcesOnStop {
            public WithCreate withDeleteResourcesOnStop(Boolean var1);
        }

        public static interface WithAutoStopDelay {
            public WithCreate withAutoStopDelay(String var1);
        }

        public static interface WithVirtualNicId {
            public WithCreate withVirtualNicId(String var1);
        }

        public static interface WithVirtualSubnetId {
            public WithCreate withVirtualSubnetId(String var1);
        }

        public static interface WithPublicKey {
            public WithCreate withPublicKey(String var1);
        }

        public static interface WithSku {
            public WithCreate withSku(ServiceSku var1);
        }

        public static interface WithKind {
            public WithCreate withKind(String var1);
        }

        public static interface WithEtag {
            public WithCreate withEtag(String var1);
        }

        public static interface WithTags {
            public WithCreate withTags(Map<String, String> var1);
        }

        public static interface WithCreate
        extends WithTags,
        WithEtag,
        WithKind,
        WithSku,
        WithPublicKey,
        WithVirtualSubnetId,
        WithVirtualNicId,
        WithAutoStopDelay,
        WithDeleteResourcesOnStop {
            public DataMigrationService create();

            public DataMigrationService create(Context var1);
        }

        public static interface WithResourceGroup {
            public WithCreate withExistingResourceGroup(String var1);
        }

        public static interface WithLocation {
            public WithResourceGroup withRegion(Region var1);

            public WithResourceGroup withRegion(String var1);
        }

        public static interface Blank
        extends WithLocation {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithLocation,
    DefinitionStages.WithResourceGroup,
    DefinitionStages.WithCreate {
    }
}

