/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ValidationError;
import java.io.IOException;
import java.util.Map;

public final class DataIntegrityValidationResult
implements JsonSerializable<DataIntegrityValidationResult> {
    private Map<String, String> failedObjects;
    private ValidationError validationErrors;

    public Map<String, String> failedObjects() {
        return this.failedObjects;
    }

    public DataIntegrityValidationResult withFailedObjects(Map<String, String> failedObjects) {
        this.failedObjects = failedObjects;
        return this;
    }

    public ValidationError validationErrors() {
        return this.validationErrors;
    }

    public DataIntegrityValidationResult withValidationErrors(ValidationError validationErrors) {
        this.validationErrors = validationErrors;
        return this;
    }

    public void validate() {
        if (this.validationErrors() != null) {
            this.validationErrors().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("failedObjects", this.failedObjects, (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("validationErrors", (JsonSerializable)this.validationErrors);
        return jsonWriter.writeEndObject();
    }

    public static DataIntegrityValidationResult fromJson(JsonReader jsonReader) throws IOException {
        return (DataIntegrityValidationResult)jsonReader.readObject(reader -> {
            DataIntegrityValidationResult deserializedDataIntegrityValidationResult = new DataIntegrityValidationResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("failedObjects".equals(fieldName)) {
                    Map failedObjects;
                    deserializedDataIntegrityValidationResult.failedObjects = failedObjects = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("validationErrors".equals(fieldName)) {
                    deserializedDataIntegrityValidationResult.validationErrors = ValidationError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDataIntegrityValidationResult;
        });
    }
}

