/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.models;

import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.fluent.models.CommandPropertiesInner;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbTaskInput;
import com.azure.resourcemanager.datamigration.models.ConnectToTargetSqlDbTaskOutput;
import com.azure.resourcemanager.datamigration.models.ProjectTaskProperties;
import com.azure.resourcemanager.datamigration.models.TaskState;
import com.azure.resourcemanager.datamigration.models.TaskType;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class ConnectToTargetSqlDbTaskProperties
extends ProjectTaskProperties {
    private TaskType taskType = TaskType.CONNECT_TO_TARGET_SQL_DB;
    private ConnectToTargetSqlDbTaskInput input;
    private List<ConnectToTargetSqlDbTaskOutput> output;
    private String createdOn;

    @Override
    public TaskType taskType() {
        return this.taskType;
    }

    public ConnectToTargetSqlDbTaskInput input() {
        return this.input;
    }

    public ConnectToTargetSqlDbTaskProperties withInput(ConnectToTargetSqlDbTaskInput input) {
        this.input = input;
        return this;
    }

    public List<ConnectToTargetSqlDbTaskOutput> output() {
        return this.output;
    }

    public String createdOn() {
        return this.createdOn;
    }

    public ConnectToTargetSqlDbTaskProperties withCreatedOn(String createdOn) {
        this.createdOn = createdOn;
        return this;
    }

    @Override
    public ConnectToTargetSqlDbTaskProperties withClientData(Map<String, String> clientData) {
        super.withClientData(clientData);
        return this;
    }

    @Override
    public void validate() {
        if (this.input() != null) {
            this.input().validate();
        }
        if (this.output() != null) {
            this.output().forEach(e -> e.validate());
        }
        if (this.commands() != null) {
            this.commands().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("clientData", this.clientData(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("taskType", this.taskType == null ? null : this.taskType.toString());
        jsonWriter.writeJsonField("input", (JsonSerializable)this.input);
        jsonWriter.writeStringField("createdOn", this.createdOn);
        return jsonWriter.writeEndObject();
    }

    public static ConnectToTargetSqlDbTaskProperties fromJson(JsonReader jsonReader) throws IOException {
        return (ConnectToTargetSqlDbTaskProperties)jsonReader.readObject(reader -> {
            ConnectToTargetSqlDbTaskProperties deserializedConnectToTargetSqlDbTaskProperties = new ConnectToTargetSqlDbTaskProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("errors".equals(fieldName)) {
                    List errors = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    deserializedConnectToTargetSqlDbTaskProperties.withErrors(errors);
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskProperties.withState(TaskState.fromString(reader.getString()));
                    continue;
                }
                if ("commands".equals(fieldName)) {
                    List commands = reader.readArray(reader1 -> CommandPropertiesInner.fromJson(reader1));
                    deserializedConnectToTargetSqlDbTaskProperties.withCommands(commands);
                    continue;
                }
                if ("clientData".equals(fieldName)) {
                    Map clientData = reader.readMap(reader1 -> reader1.getString());
                    deserializedConnectToTargetSqlDbTaskProperties.withClientData(clientData);
                    continue;
                }
                if ("taskType".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskProperties.taskType = TaskType.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskProperties.input = ConnectToTargetSqlDbTaskInput.fromJson(reader);
                    continue;
                }
                if ("output".equals(fieldName)) {
                    List output;
                    deserializedConnectToTargetSqlDbTaskProperties.output = output = reader.readArray(reader1 -> ConnectToTargetSqlDbTaskOutput.fromJson(reader1));
                    continue;
                }
                if ("createdOn".equals(fieldName)) {
                    deserializedConnectToTargetSqlDbTaskProperties.createdOn = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedConnectToTargetSqlDbTaskProperties;
        });
    }
}

