/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.BinaryData;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datamigration.fluent.DatabaseMigrationsSqlVmsClient;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlVmInner;
import com.azure.resourcemanager.datamigration.implementation.DataMigrationManagementClientImpl;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.UUID;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class DatabaseMigrationsSqlVmsClientImpl
implements DatabaseMigrationsSqlVmsClient {
    private final DatabaseMigrationsSqlVmsService service;
    private final DataMigrationManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(DatabaseMigrationsSqlVmsClientImpl.class);

    DatabaseMigrationsSqlVmsClientImpl(DataMigrationManagementClientImpl client) {
        this.service = (DatabaseMigrationsSqlVmsService)RestProxy.create(DatabaseMigrationsSqlVmsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<DatabaseMigrationSqlVmInner>> getWithResponseAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, UUID migrationOperationId, String expand) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationSqlVmInner> getAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName) {
        UUID migrationOperationId = null;
        String expand = null;
        return this.getWithResponseAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand).flatMap(res -> Mono.justOrEmpty((Object)((Object)((DatabaseMigrationSqlVmInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<DatabaseMigrationSqlVmInner> getWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, UUID migrationOperationId, String expand, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand, this.client.getSubscriptionId(), this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlVmInner get(String resourceGroupName, String sqlVirtualMachineName, String targetDbName) {
        UUID migrationOperationId = null;
        String expand = null;
        return (DatabaseMigrationSqlVmInner)((Object)this.getWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, migrationOperationId, expand, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> createOrUpdateWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, "application/json", context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<DatabaseMigrationSqlVmInner>, DatabaseMigrationSqlVmInner> beginCreateOrUpdateAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.createOrUpdateWithResponseAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)DatabaseMigrationSqlVmInner.class), (Type)((Object)DatabaseMigrationSqlVmInner.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlVmInner>, DatabaseMigrationSqlVmInner> beginCreateOrUpdate(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlVmInner.class), (Type)((Object)DatabaseMigrationSqlVmInner.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<DatabaseMigrationSqlVmInner>, DatabaseMigrationSqlVmInner> beginCreateOrUpdate(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters, Context context) {
        Response<BinaryData> response = this.createOrUpdateWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)DatabaseMigrationSqlVmInner.class), (Type)((Object)DatabaseMigrationSqlVmInner.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<DatabaseMigrationSqlVmInner> createOrUpdateAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        return this.beginCreateOrUpdateAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlVmInner createOrUpdate(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters) {
        return (DatabaseMigrationSqlVmInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).getFinalResult());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public DatabaseMigrationSqlVmInner createOrUpdate(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, DatabaseMigrationSqlVmInner parameters, Context context) {
        return (DatabaseMigrationSqlVmInner)((Object)this.beginCreateOrUpdate(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context).getFinalResult());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cancelWithResponseAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.cancel(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cancelWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cancelSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cancelWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cancelSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCancelAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.cancelWithResponseAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        Response<BinaryData> response = this.cancelWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        Response<BinaryData> response = this.cancelWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> cancelAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        return this.beginCancelAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        this.beginCancel(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cancel(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.beginCancel(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context).getFinalResult();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> cutoverWithResponseAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return FluxUtil.withContext(context -> this.service.cutover(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cutoverWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cutoverSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Response<BinaryData> cutoverWithResponse(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (sqlVirtualMachineName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter sqlVirtualMachineName is required and cannot be null."));
        }
        if (targetDbName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter targetDbName is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (parameters == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        return this.service.cutoverSync(this.client.getEndpoint(), resourceGroupName, sqlVirtualMachineName, targetDbName, this.client.getSubscriptionId(), this.client.getApiVersion(), parameters, context);
    }

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginCutoverAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        Mono<Response<Flux<ByteBuffer>>> mono = this.cutoverWithResponseAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(mono, this.client.getHttpPipeline(), (Type)((Object)Void.class), (Type)((Object)Void.class), this.client.getContext());
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        Response<BinaryData> response = this.cutoverWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), Context.NONE);
    }

    @Override
    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginCutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        Response<BinaryData> response = this.cutoverWithResponse(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context);
        return this.client.getLroResult(response, (Type)((Object)Void.class), (Type)((Object)Void.class), context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> cutoverAsync(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        return this.beginCutoverAsync(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).last().flatMap(this.client::getLroFinalResultOrError);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters) {
        this.beginCutover(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters).getFinalResult();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void cutover(String resourceGroupName, String sqlVirtualMachineName, String targetDbName, MigrationOperationInput parameters, Context context) {
        this.beginCutover(resourceGroupName, sqlVirtualMachineName, targetDbName, parameters, context).getFinalResult();
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataMigrationManagementClientDatabaseMigrationsSqlVms")
    public static interface DatabaseMigrationsSqlVmsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<DatabaseMigrationSqlVmInner>> get(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="migrationOperationId") UUID var5, @QueryParam(value="$expand") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<DatabaseMigrationSqlVmInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @QueryParam(value="migrationOperationId") UUID var5, @QueryParam(value="$expand") String var6, @PathParam(value="subscriptionId") String var7, @QueryParam(value="api-version") String var8, @HeaderParam(value="Accept") String var9, Context var10);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationSqlVmInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") DatabaseMigrationSqlVmInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cancel")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> cancel(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cancel")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> cancelSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cutover")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Flux<ByteBuffer>>> cutover(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);

        @Headers(value={"Accept: application/json;q=0.9", "Content-Type: application/json"})
        @Post(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.SqlVirtualMachine/sqlVirtualMachines/{sqlVirtualMachineName}/providers/Microsoft.DataMigration/databaseMigrations/{targetDbName}/cutover")
        @ExpectedResponses(value={200, 202})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<BinaryData> cutoverSync(@HostParam(value="$host") String var1, @PathParam(value="resourceGroupName") String var2, @PathParam(value="sqlVirtualMachineName") String var3, @PathParam(value="targetDbName") String var4, @PathParam(value="subscriptionId") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") MigrationOperationInput var7, Context var8);
    }
}

