/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.implementation;

import com.azure.core.util.Context;
import com.azure.resourcemanager.datamigration.DataMigrationManager;
import com.azure.resourcemanager.datamigration.fluent.models.DatabaseMigrationSqlMiInner;
import com.azure.resourcemanager.datamigration.implementation.ResourceManagerUtils;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationPropertiesSqlMi;
import com.azure.resourcemanager.datamigration.models.DatabaseMigrationSqlMi;
import com.azure.resourcemanager.datamigration.models.MigrationOperationInput;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.util.UUID;

public final class DatabaseMigrationSqlMiImpl
implements DatabaseMigrationSqlMi,
DatabaseMigrationSqlMi.Definition,
DatabaseMigrationSqlMi.Update {
    private DatabaseMigrationSqlMiInner innerObject;
    private final DataMigrationManager serviceManager;
    private String resourceGroupName;
    private String managedInstanceName;
    private String targetDbName;

    @Override
    public String id() {
        return this.innerModel().id();
    }

    @Override
    public String name() {
        return this.innerModel().name();
    }

    @Override
    public String type() {
        return this.innerModel().type();
    }

    @Override
    public DatabaseMigrationPropertiesSqlMi properties() {
        return this.innerModel().properties();
    }

    @Override
    public SystemDataAutoGenerated systemData() {
        return this.innerModel().systemData();
    }

    @Override
    public String resourceGroupName() {
        return this.resourceGroupName;
    }

    @Override
    public DatabaseMigrationSqlMiInner innerModel() {
        return this.innerObject;
    }

    private DataMigrationManager manager() {
        return this.serviceManager;
    }

    @Override
    public DatabaseMigrationSqlMiImpl withExistingManagedInstance(String resourceGroupName, String managedInstanceName) {
        this.resourceGroupName = resourceGroupName;
        this.managedInstanceName = managedInstanceName;
        return this;
    }

    @Override
    public DatabaseMigrationSqlMi create() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().createOrUpdate(this.resourceGroupName, this.managedInstanceName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlMi create(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().createOrUpdate(this.resourceGroupName, this.managedInstanceName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlMiImpl(String name, DataMigrationManager serviceManager) {
        this.innerObject = new DatabaseMigrationSqlMiInner();
        this.serviceManager = serviceManager;
        this.targetDbName = name;
    }

    @Override
    public DatabaseMigrationSqlMiImpl update() {
        return this;
    }

    @Override
    public DatabaseMigrationSqlMi apply() {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().createOrUpdate(this.resourceGroupName, this.managedInstanceName, this.targetDbName, this.innerModel(), Context.NONE);
        return this;
    }

    @Override
    public DatabaseMigrationSqlMi apply(Context context) {
        this.innerObject = this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().createOrUpdate(this.resourceGroupName, this.managedInstanceName, this.targetDbName, this.innerModel(), context);
        return this;
    }

    DatabaseMigrationSqlMiImpl(DatabaseMigrationSqlMiInner innerObject, DataMigrationManager serviceManager) {
        this.innerObject = innerObject;
        this.serviceManager = serviceManager;
        this.resourceGroupName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "resourceGroups");
        this.managedInstanceName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "managedInstances");
        this.targetDbName = ResourceManagerUtils.getValueFromIdByName(innerObject.id(), "databaseMigrations");
    }

    @Override
    public DatabaseMigrationSqlMi refresh() {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlMiInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().getWithResponse(this.resourceGroupName, this.managedInstanceName, this.targetDbName, localMigrationOperationId, localExpand, Context.NONE).getValue());
        return this;
    }

    @Override
    public DatabaseMigrationSqlMi refresh(Context context) {
        UUID localMigrationOperationId = null;
        String localExpand = null;
        this.innerObject = (DatabaseMigrationSqlMiInner)((Object)this.serviceManager.serviceClient().getDatabaseMigrationsSqlMis().getWithResponse(this.resourceGroupName, this.managedInstanceName, this.targetDbName, localMigrationOperationId, localExpand, context).getValue());
        return this;
    }

    @Override
    public void cancel(MigrationOperationInput parameters) {
        this.serviceManager.databaseMigrationsSqlMis().cancel(this.resourceGroupName, this.managedInstanceName, this.targetDbName, parameters);
    }

    @Override
    public void cancel(MigrationOperationInput parameters, Context context) {
        this.serviceManager.databaseMigrationsSqlMis().cancel(this.resourceGroupName, this.managedInstanceName, this.targetDbName, parameters, context);
    }

    @Override
    public void cutover(MigrationOperationInput parameters) {
        this.serviceManager.databaseMigrationsSqlMis().cutover(this.resourceGroupName, this.managedInstanceName, this.targetDbName, parameters);
    }

    @Override
    public void cutover(MigrationOperationInput parameters, Context context) {
        this.serviceManager.databaseMigrationsSqlMis().cutover(this.resourceGroupName, this.managedInstanceName, this.targetDbName, parameters, context);
    }

    @Override
    public DatabaseMigrationSqlMiImpl withProperties(DatabaseMigrationPropertiesSqlMi properties) {
        this.innerModel().withProperties(properties);
        return this;
    }
}

