/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.ProjectFileProperties;
import com.azure.resourcemanager.datamigration.models.SystemDataAutoGenerated;
import java.io.IOException;

public final class ProjectFileInner
extends ProxyResource {
    private String etag;
    private ProjectFileProperties properties;
    private SystemDataAutoGenerated systemData;
    private String type;
    private String name;
    private String id;

    public String etag() {
        return this.etag;
    }

    public ProjectFileInner withEtag(String etag) {
        this.etag = etag;
        return this;
    }

    public ProjectFileProperties properties() {
        return this.properties;
    }

    public ProjectFileInner withProperties(ProjectFileProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemDataAutoGenerated systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
        if (this.systemData() != null) {
            this.systemData().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("etag", this.etag);
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static ProjectFileInner fromJson(JsonReader jsonReader) throws IOException {
        return (ProjectFileInner)((Object)jsonReader.readObject(reader -> {
            ProjectFileInner deserializedProjectFileInner = new ProjectFileInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedProjectFileInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedProjectFileInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedProjectFileInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedProjectFileInner.etag = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedProjectFileInner.properties = ProjectFileProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedProjectFileInner.systemData = SystemDataAutoGenerated.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedProjectFileInner;
        }));
    }
}

