/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datamigration.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datamigration.models.OperationOrigin;
import com.azure.resourcemanager.datamigration.models.OperationsDisplayDefinition;
import java.io.IOException;
import java.util.Map;

public final class OperationsDefinitionInner
implements JsonSerializable<OperationsDefinitionInner> {
    private String name;
    private Boolean isDataAction;
    private OperationsDisplayDefinition display;
    private OperationOrigin origin;
    private Map<String, Object> properties;

    public String name() {
        return this.name;
    }

    public Boolean isDataAction() {
        return this.isDataAction;
    }

    public OperationsDefinitionInner withIsDataAction(Boolean isDataAction) {
        this.isDataAction = isDataAction;
        return this;
    }

    public OperationsDisplayDefinition display() {
        return this.display;
    }

    public OperationOrigin origin() {
        return this.origin;
    }

    public Map<String, Object> properties() {
        return this.properties;
    }

    public void validate() {
        if (this.display() != null) {
            this.display().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("isDataAction", this.isDataAction);
        return jsonWriter.writeEndObject();
    }

    public static OperationsDefinitionInner fromJson(JsonReader jsonReader) throws IOException {
        return (OperationsDefinitionInner)jsonReader.readObject(reader -> {
            OperationsDefinitionInner deserializedOperationsDefinitionInner = new OperationsDefinitionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.name = reader.getString();
                    continue;
                }
                if ("isDataAction".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.isDataAction = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("display".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.display = OperationsDisplayDefinition.fromJson(reader);
                    continue;
                }
                if ("origin".equals(fieldName)) {
                    deserializedOperationsDefinitionInner.origin = OperationOrigin.fromString(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedOperationsDefinitionInner.properties = properties = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedOperationsDefinitionInner;
        });
    }
}

