/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.DWCopyCommandSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class WarehouseSink
extends CopySink {
    private String type = "WarehouseSink";
    private Object preCopyScript;
    private Object allowCopyCommand;
    private DWCopyCommandSettings copyCommandSettings;
    private Object tableOption;
    private Object writeBehavior;

    @Override
    public String type() {
        return this.type;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public WarehouseSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public Object allowCopyCommand() {
        return this.allowCopyCommand;
    }

    public WarehouseSink withAllowCopyCommand(Object allowCopyCommand) {
        this.allowCopyCommand = allowCopyCommand;
        return this;
    }

    public DWCopyCommandSettings copyCommandSettings() {
        return this.copyCommandSettings;
    }

    public WarehouseSink withCopyCommandSettings(DWCopyCommandSettings copyCommandSettings) {
        this.copyCommandSettings = copyCommandSettings;
        return this;
    }

    public Object tableOption() {
        return this.tableOption;
    }

    public WarehouseSink withTableOption(Object tableOption) {
        this.tableOption = tableOption;
        return this;
    }

    public Object writeBehavior() {
        return this.writeBehavior;
    }

    public WarehouseSink withWriteBehavior(Object writeBehavior) {
        this.writeBehavior = writeBehavior;
        return this;
    }

    @Override
    public WarehouseSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public WarehouseSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public WarehouseSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public WarehouseSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public WarehouseSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public WarehouseSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.copyCommandSettings() != null) {
            this.copyCommandSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        if (this.allowCopyCommand != null) {
            jsonWriter.writeUntypedField("allowCopyCommand", this.allowCopyCommand);
        }
        jsonWriter.writeJsonField("copyCommandSettings", (JsonSerializable)this.copyCommandSettings);
        if (this.tableOption != null) {
            jsonWriter.writeUntypedField("tableOption", this.tableOption);
        }
        if (this.writeBehavior != null) {
            jsonWriter.writeUntypedField("writeBehavior", this.writeBehavior);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static WarehouseSink fromJson(JsonReader jsonReader) throws IOException {
        return (WarehouseSink)jsonReader.readObject(reader -> {
            WarehouseSink deserializedWarehouseSink = new WarehouseSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedWarehouseSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedWarehouseSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedWarehouseSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedWarehouseSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedWarehouseSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedWarehouseSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedWarehouseSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedWarehouseSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("allowCopyCommand".equals(fieldName)) {
                    deserializedWarehouseSink.allowCopyCommand = reader.readUntyped();
                    continue;
                }
                if ("copyCommandSettings".equals(fieldName)) {
                    deserializedWarehouseSink.copyCommandSettings = DWCopyCommandSettings.fromJson(reader);
                    continue;
                }
                if ("tableOption".equals(fieldName)) {
                    deserializedWarehouseSink.tableOption = reader.readUntyped();
                    continue;
                }
                if ("writeBehavior".equals(fieldName)) {
                    deserializedWarehouseSink.writeBehavior = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedWarehouseSink.withAdditionalProperties(additionalProperties);
            return deserializedWarehouseSink;
        });
    }
}

