/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TriggerRunStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public final class TriggerRun
implements JsonSerializable<TriggerRun> {
    private String triggerRunId;
    private String triggerName;
    private String triggerType;
    private OffsetDateTime triggerRunTimestamp;
    private TriggerRunStatus status;
    private String message;
    private Map<String, String> properties;
    private Map<String, String> triggeredPipelines;
    private Map<String, String> runDimension;
    private Map<String, Object> dependencyStatus;
    private Map<String, Object> additionalProperties;

    public String triggerRunId() {
        return this.triggerRunId;
    }

    public String triggerName() {
        return this.triggerName;
    }

    public String triggerType() {
        return this.triggerType;
    }

    public OffsetDateTime triggerRunTimestamp() {
        return this.triggerRunTimestamp;
    }

    public TriggerRunStatus status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }

    public Map<String, String> properties() {
        return this.properties;
    }

    public Map<String, String> triggeredPipelines() {
        return this.triggeredPipelines;
    }

    public Map<String, String> runDimension() {
        return this.runDimension;
    }

    public Map<String, Object> dependencyStatus() {
        return this.dependencyStatus;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public TriggerRun withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static TriggerRun fromJson(JsonReader jsonReader) throws IOException {
        return (TriggerRun)jsonReader.readObject(reader -> {
            TriggerRun deserializedTriggerRun = new TriggerRun();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("triggerRunId".equals(fieldName)) {
                    deserializedTriggerRun.triggerRunId = reader.getString();
                    continue;
                }
                if ("triggerName".equals(fieldName)) {
                    deserializedTriggerRun.triggerName = reader.getString();
                    continue;
                }
                if ("triggerType".equals(fieldName)) {
                    deserializedTriggerRun.triggerType = reader.getString();
                    continue;
                }
                if ("triggerRunTimestamp".equals(fieldName)) {
                    deserializedTriggerRun.triggerRunTimestamp = (OffsetDateTime)reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime((String)nonNullReader.getString()));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedTriggerRun.status = TriggerRunStatus.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedTriggerRun.message = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    Map properties;
                    deserializedTriggerRun.properties = properties = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("triggeredPipelines".equals(fieldName)) {
                    Map triggeredPipelines;
                    deserializedTriggerRun.triggeredPipelines = triggeredPipelines = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("runDimension".equals(fieldName)) {
                    Map runDimension;
                    deserializedTriggerRun.runDimension = runDimension = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("dependencyStatus".equals(fieldName)) {
                    Map dependencyStatus;
                    deserializedTriggerRun.dependencyStatus = dependencyStatus = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedTriggerRun.additionalProperties = additionalProperties;
            return deserializedTriggerRun;
        });
    }
}

