/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.DataFlowReference;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import java.io.IOException;

public class Transformation
implements JsonSerializable<Transformation> {
    private String name;
    private String description;
    private DatasetReference dataset;
    private LinkedServiceReference linkedService;
    private DataFlowReference flowlet;
    private static final ClientLogger LOGGER = new ClientLogger(Transformation.class);

    public String name() {
        return this.name;
    }

    public Transformation withName(String name) {
        this.name = name;
        return this;
    }

    public String description() {
        return this.description;
    }

    public Transformation withDescription(String description) {
        this.description = description;
        return this;
    }

    public DatasetReference dataset() {
        return this.dataset;
    }

    public Transformation withDataset(DatasetReference dataset) {
        this.dataset = dataset;
        return this;
    }

    public LinkedServiceReference linkedService() {
        return this.linkedService;
    }

    public Transformation withLinkedService(LinkedServiceReference linkedService) {
        this.linkedService = linkedService;
        return this;
    }

    public DataFlowReference flowlet() {
        return this.flowlet;
    }

    public Transformation withFlowlet(DataFlowReference flowlet) {
        this.flowlet = flowlet;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model Transformation"));
        }
        if (this.dataset() != null) {
            this.dataset().validate();
        }
        if (this.linkedService() != null) {
            this.linkedService().validate();
        }
        if (this.flowlet() != null) {
            this.flowlet().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeJsonField("dataset", (JsonSerializable)this.dataset);
        jsonWriter.writeJsonField("linkedService", (JsonSerializable)this.linkedService);
        jsonWriter.writeJsonField("flowlet", (JsonSerializable)this.flowlet);
        return jsonWriter.writeEndObject();
    }

    public static Transformation fromJson(JsonReader jsonReader) throws IOException {
        return (Transformation)jsonReader.readObject(reader -> {
            Transformation deserializedTransformation = new Transformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedTransformation.name = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedTransformation.description = reader.getString();
                    continue;
                }
                if ("dataset".equals(fieldName)) {
                    deserializedTransformation.dataset = DatasetReference.fromJson(reader);
                    continue;
                }
                if ("linkedService".equals(fieldName)) {
                    deserializedTransformation.linkedService = LinkedServiceReference.fromJson(reader);
                    continue;
                }
                if ("flowlet".equals(fieldName)) {
                    deserializedTransformation.flowlet = DataFlowReference.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedTransformation;
        });
    }
}

