/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadata;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataType;
import com.azure.resourcemanager.datafactory.models.SsisVariable;
import java.io.IOException;
import java.util.List;

public final class SsisEnvironment
extends SsisObjectMetadata {
    private SsisObjectMetadataType type = SsisObjectMetadataType.ENVIRONMENT;
    private Long folderId;
    private List<SsisVariable> variables;

    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    public Long folderId() {
        return this.folderId;
    }

    public SsisEnvironment withFolderId(Long folderId) {
        this.folderId = folderId;
        return this;
    }

    public List<SsisVariable> variables() {
        return this.variables;
    }

    public SsisEnvironment withVariables(List<SsisVariable> variables) {
        this.variables = variables;
        return this;
    }

    @Override
    public SsisEnvironment withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public SsisEnvironment withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SsisEnvironment withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.variables() != null) {
            this.variables().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", (Number)this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("folderId", (Number)this.folderId);
        jsonWriter.writeArrayField("variables", this.variables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SsisEnvironment fromJson(JsonReader jsonReader) throws IOException {
        return (SsisEnvironment)jsonReader.readObject(reader -> {
            SsisEnvironment deserializedSsisEnvironment = new SsisEnvironment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSsisEnvironment.withId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSsisEnvironment.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSsisEnvironment.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisEnvironment.type = SsisObjectMetadataType.fromString(reader.getString());
                    continue;
                }
                if ("folderId".equals(fieldName)) {
                    deserializedSsisEnvironment.folderId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("variables".equals(fieldName)) {
                    List variables;
                    deserializedSsisEnvironment.variables = variables = reader.readArray(reader1 -> SsisVariable.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisEnvironment;
        });
    }
}

