/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class SsisAccessCredential
implements JsonSerializable<SsisAccessCredential> {
    private Object domain;
    private Object username;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(SsisAccessCredential.class);

    public Object domain() {
        return this.domain;
    }

    public SsisAccessCredential withDomain(Object domain) {
        this.domain = domain;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public SsisAccessCredential withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public SsisAccessCredential withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public void validate() {
        if (this.domain() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property domain in model SsisAccessCredential"));
        }
        if (this.username() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property username in model SsisAccessCredential"));
        }
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model SsisAccessCredential"));
        }
        this.password().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("domain", this.domain);
        jsonWriter.writeUntypedField("userName", this.username);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        return jsonWriter.writeEndObject();
    }

    public static SsisAccessCredential fromJson(JsonReader jsonReader) throws IOException {
        return (SsisAccessCredential)jsonReader.readObject(reader -> {
            SsisAccessCredential deserializedSsisAccessCredential = new SsisAccessCredential();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("domain".equals(fieldName)) {
                    deserializedSsisAccessCredential.domain = reader.readUntyped();
                    continue;
                }
                if ("userName".equals(fieldName)) {
                    deserializedSsisAccessCredential.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedSsisAccessCredential.password = SecretBase.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisAccessCredential;
        });
    }
}

