/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.SnowflakeExportCopyCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeSource
extends CopySource {
    private String type = "SnowflakeSource";
    private Object query;
    private SnowflakeExportCopyCommand exportSettings;
    private static final ClientLogger LOGGER = new ClientLogger(SnowflakeSource.class);

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public SnowflakeSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    public SnowflakeExportCopyCommand exportSettings() {
        return this.exportSettings;
    }

    public SnowflakeSource withExportSettings(SnowflakeExportCopyCommand exportSettings) {
        this.exportSettings = exportSettings;
        return this;
    }

    @Override
    public SnowflakeSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public SnowflakeSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public SnowflakeSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SnowflakeSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.exportSettings() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property exportSettings in model SnowflakeSource"));
        }
        this.exportSettings().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeJsonField("exportSettings", (JsonSerializable)this.exportSettings);
        jsonWriter.writeStringField("type", this.type);
        if (this.query != null) {
            jsonWriter.writeUntypedField("query", this.query);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeSource fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeSource)jsonReader.readObject(reader -> {
            SnowflakeSource deserializedSnowflakeSource = new SnowflakeSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedSnowflakeSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedSnowflakeSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSnowflakeSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("exportSettings".equals(fieldName)) {
                    deserializedSnowflakeSource.exportSettings = SnowflakeExportCopyCommand.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedSnowflakeSource.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeSource.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeSource;
        });
    }
}

