/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class RestSource
extends CopySource {
    private String type = "RestSource";
    private Object requestMethod;
    private Object requestBody;
    private Object additionalHeaders;
    private Object paginationRules;
    private Object httpRequestTimeout;
    private Object requestInterval;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object requestMethod() {
        return this.requestMethod;
    }

    public RestSource withRequestMethod(Object requestMethod) {
        this.requestMethod = requestMethod;
        return this;
    }

    public Object requestBody() {
        return this.requestBody;
    }

    public RestSource withRequestBody(Object requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Object additionalHeaders() {
        return this.additionalHeaders;
    }

    public RestSource withAdditionalHeaders(Object additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
        return this;
    }

    public Object paginationRules() {
        return this.paginationRules;
    }

    public RestSource withPaginationRules(Object paginationRules) {
        this.paginationRules = paginationRules;
        return this;
    }

    public Object httpRequestTimeout() {
        return this.httpRequestTimeout;
    }

    public RestSource withHttpRequestTimeout(Object httpRequestTimeout) {
        this.httpRequestTimeout = httpRequestTimeout;
        return this;
    }

    public Object requestInterval() {
        return this.requestInterval;
    }

    public RestSource withRequestInterval(Object requestInterval) {
        this.requestInterval = requestInterval;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public RestSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public RestSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public RestSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public RestSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public RestSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.sourceRetryCount() != null) {
            jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        }
        if (this.sourceRetryWait() != null) {
            jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.requestMethod != null) {
            jsonWriter.writeUntypedField("requestMethod", this.requestMethod);
        }
        if (this.requestBody != null) {
            jsonWriter.writeUntypedField("requestBody", this.requestBody);
        }
        if (this.additionalHeaders != null) {
            jsonWriter.writeUntypedField("additionalHeaders", this.additionalHeaders);
        }
        if (this.paginationRules != null) {
            jsonWriter.writeUntypedField("paginationRules", this.paginationRules);
        }
        if (this.httpRequestTimeout != null) {
            jsonWriter.writeUntypedField("httpRequestTimeout", this.httpRequestTimeout);
        }
        if (this.requestInterval != null) {
            jsonWriter.writeUntypedField("requestInterval", this.requestInterval);
        }
        if (this.additionalColumns != null) {
            jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        }
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static RestSource fromJson(JsonReader jsonReader) throws IOException {
        return (RestSource)jsonReader.readObject(reader -> {
            RestSource deserializedRestSource = new RestSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedRestSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedRestSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedRestSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedRestSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRestSource.type = reader.getString();
                    continue;
                }
                if ("requestMethod".equals(fieldName)) {
                    deserializedRestSource.requestMethod = reader.readUntyped();
                    continue;
                }
                if ("requestBody".equals(fieldName)) {
                    deserializedRestSource.requestBody = reader.readUntyped();
                    continue;
                }
                if ("additionalHeaders".equals(fieldName)) {
                    deserializedRestSource.additionalHeaders = reader.readUntyped();
                    continue;
                }
                if ("paginationRules".equals(fieldName)) {
                    deserializedRestSource.paginationRules = reader.readUntyped();
                    continue;
                }
                if ("httpRequestTimeout".equals(fieldName)) {
                    deserializedRestSource.httpRequestTimeout = reader.readUntyped();
                    continue;
                }
                if ("requestInterval".equals(fieldName)) {
                    deserializedRestSource.requestInterval = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedRestSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedRestSource.withAdditionalProperties(additionalProperties);
            return deserializedRestSource;
        });
    }
}

