/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.MongoDbAtlasCollectionDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class MongoDbAtlasCollectionDataset
extends Dataset {
    private String type = "MongoDbAtlasCollection";
    private MongoDbAtlasCollectionDatasetTypeProperties innerTypeProperties = new MongoDbAtlasCollectionDatasetTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbAtlasCollectionDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    MongoDbAtlasCollectionDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public MongoDbAtlasCollectionDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public MongoDbAtlasCollectionDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object collection() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().collection();
    }

    public MongoDbAtlasCollectionDataset withCollection(Object collection) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new MongoDbAtlasCollectionDatasetTypeProperties();
        }
        this.innerTypeProperties().withCollection(collection);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model MongoDbAtlasCollectionDataset"));
        }
        this.innerTypeProperties().validate();
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model MongoDbAtlasCollectionDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        if (this.structure() != null) {
            jsonWriter.writeUntypedField("structure", this.structure());
        }
        if (this.schema() != null) {
            jsonWriter.writeUntypedField("schema", this.schema());
        }
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MongoDbAtlasCollectionDataset fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbAtlasCollectionDataset)jsonReader.readObject(reader -> {
            MongoDbAtlasCollectionDataset deserializedMongoDbAtlasCollectionDataset = new MongoDbAtlasCollectionDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedMongoDbAtlasCollectionDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMongoDbAtlasCollectionDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.innerTypeProperties = MongoDbAtlasCollectionDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMongoDbAtlasCollectionDataset.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMongoDbAtlasCollectionDataset.withAdditionalProperties(additionalProperties);
            return deserializedMongoDbAtlasCollectionDataset;
        });
    }
}

