/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AmazonS3CompatibleLocation;
import com.azure.resourcemanager.datafactory.models.AmazonS3Location;
import com.azure.resourcemanager.datafactory.models.AzureBlobFSLocation;
import com.azure.resourcemanager.datafactory.models.AzureBlobStorageLocation;
import com.azure.resourcemanager.datafactory.models.AzureDataLakeStoreLocation;
import com.azure.resourcemanager.datafactory.models.AzureFileStorageLocation;
import com.azure.resourcemanager.datafactory.models.FileServerLocation;
import com.azure.resourcemanager.datafactory.models.FtpServerLocation;
import com.azure.resourcemanager.datafactory.models.GoogleCloudStorageLocation;
import com.azure.resourcemanager.datafactory.models.HdfsLocation;
import com.azure.resourcemanager.datafactory.models.HttpServerLocation;
import com.azure.resourcemanager.datafactory.models.LakeHouseLocation;
import com.azure.resourcemanager.datafactory.models.OracleCloudStorageLocation;
import com.azure.resourcemanager.datafactory.models.SftpLocation;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class DatasetLocation
implements JsonSerializable<DatasetLocation> {
    private String type = "DatasetLocation";
    private Object folderPath;
    private Object fileName;
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public Object folderPath() {
        return this.folderPath;
    }

    public DatasetLocation withFolderPath(Object folderPath) {
        this.folderPath = folderPath;
        return this;
    }

    public Object fileName() {
        return this.fileName;
    }

    public DatasetLocation withFileName(Object fileName) {
        this.fileName = fileName;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public DatasetLocation withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.folderPath != null) {
            jsonWriter.writeUntypedField("folderPath", this.folderPath);
        }
        if (this.fileName != null) {
            jsonWriter.writeUntypedField("fileName", this.fileName);
        }
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static DatasetLocation fromJson(JsonReader jsonReader) throws IOException {
        return (DatasetLocation)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                DatasetLocation datasetLocation;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("AzureBlobStorageLocation".equals(discriminatorValue)) {
                    datasetLocation = AzureBlobStorageLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("AzureBlobFSLocation".equals(discriminatorValue)) {
                    datasetLocation = AzureBlobFSLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("AzureDataLakeStoreLocation".equals(discriminatorValue)) {
                    datasetLocation = AzureDataLakeStoreLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("AmazonS3Location".equals(discriminatorValue)) {
                    datasetLocation = AmazonS3Location.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("FileServerLocation".equals(discriminatorValue)) {
                    datasetLocation = FileServerLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("AzureFileStorageLocation".equals(discriminatorValue)) {
                    datasetLocation = AzureFileStorageLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("AmazonS3CompatibleLocation".equals(discriminatorValue)) {
                    datasetLocation = AmazonS3CompatibleLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("OracleCloudStorageLocation".equals(discriminatorValue)) {
                    datasetLocation = OracleCloudStorageLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("GoogleCloudStorageLocation".equals(discriminatorValue)) {
                    datasetLocation = GoogleCloudStorageLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("FtpServerLocation".equals(discriminatorValue)) {
                    datasetLocation = FtpServerLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("SftpLocation".equals(discriminatorValue)) {
                    datasetLocation = SftpLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("HttpServerLocation".equals(discriminatorValue)) {
                    datasetLocation = HttpServerLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("HdfsLocation".equals(discriminatorValue)) {
                    datasetLocation = HdfsLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                if ("LakeHouseLocation".equals(discriminatorValue)) {
                    datasetLocation = LakeHouseLocation.fromJson(readerToUse.reset());
                    return datasetLocation;
                }
                datasetLocation = DatasetLocation.fromJsonKnownDiscriminator(readerToUse.reset());
                return datasetLocation;
            }
        });
    }

    static DatasetLocation fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (DatasetLocation)jsonReader.readObject(reader -> {
            DatasetLocation deserializedDatasetLocation = new DatasetLocation();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedDatasetLocation.type = reader.getString();
                    continue;
                }
                if ("folderPath".equals(fieldName)) {
                    deserializedDatasetLocation.folderPath = reader.readUntyped();
                    continue;
                }
                if ("fileName".equals(fieldName)) {
                    deserializedDatasetLocation.fileName = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedDatasetLocation.additionalProperties = additionalProperties;
            return deserializedDatasetLocation;
        });
    }
}

