/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.AzureSqlDWLinkedServiceTypeProperties;
import com.azure.resourcemanager.datafactory.models.AzureKeyVaultSecretReference;
import com.azure.resourcemanager.datafactory.models.AzureSqlDWAuthenticationType;
import com.azure.resourcemanager.datafactory.models.CredentialReference;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeReference;
import com.azure.resourcemanager.datafactory.models.LinkedService;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class AzureSqlDWLinkedService
extends LinkedService {
    private String type = "AzureSqlDW";
    private AzureSqlDWLinkedServiceTypeProperties innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(AzureSqlDWLinkedService.class);

    @Override
    public String type() {
        return this.type;
    }

    AzureSqlDWLinkedServiceTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public AzureSqlDWLinkedService withVersion(String version) {
        super.withVersion(version);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService withConnectVia(IntegrationRuntimeReference connectVia) {
        super.withConnectVia(connectVia);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public AzureSqlDWLinkedService withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    public Object connectionString() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectionString();
    }

    public AzureSqlDWLinkedService withConnectionString(Object connectionString) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectionString(connectionString);
        return this;
    }

    public AzureSqlDWAuthenticationType authenticationType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().authenticationType();
    }

    public AzureSqlDWLinkedService withAuthenticationType(AzureSqlDWAuthenticationType authenticationType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAuthenticationType(authenticationType);
        return this;
    }

    public Object username() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().username();
    }

    public AzureSqlDWLinkedService withUsername(Object username) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withUsername(username);
        return this;
    }

    public AzureKeyVaultSecretReference password() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().password();
    }

    public AzureSqlDWLinkedService withPassword(AzureKeyVaultSecretReference password) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPassword(password);
        return this;
    }

    public Object servicePrincipalId() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalId();
    }

    public AzureSqlDWLinkedService withServicePrincipalId(Object servicePrincipalId) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalId(servicePrincipalId);
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalKey();
    }

    public AzureSqlDWLinkedService withServicePrincipalKey(SecretBase servicePrincipalKey) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalKey(servicePrincipalKey);
        return this;
    }

    public Object servicePrincipalCredentialType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalCredentialType();
    }

    public AzureSqlDWLinkedService withServicePrincipalCredentialType(Object servicePrincipalCredentialType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalCredentialType(servicePrincipalCredentialType);
        return this;
    }

    public SecretBase servicePrincipalCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().servicePrincipalCredential();
    }

    public AzureSqlDWLinkedService withServicePrincipalCredential(SecretBase servicePrincipalCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServicePrincipalCredential(servicePrincipalCredential);
        return this;
    }

    public Object tenant() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().tenant();
    }

    public AzureSqlDWLinkedService withTenant(Object tenant) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTenant(tenant);
        return this;
    }

    public Object azureCloudType() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().azureCloudType();
    }

    public AzureSqlDWLinkedService withAzureCloudType(Object azureCloudType) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withAzureCloudType(azureCloudType);
        return this;
    }

    public String encryptedCredential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encryptedCredential();
    }

    public AzureSqlDWLinkedService withEncryptedCredential(String encryptedCredential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncryptedCredential(encryptedCredential);
        return this;
    }

    public CredentialReference credential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().credential();
    }

    public AzureSqlDWLinkedService withCredential(CredentialReference credential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCredential(credential);
        return this;
    }

    public Object server() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().server();
    }

    public AzureSqlDWLinkedService withServer(Object server) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withServer(server);
        return this;
    }

    public Object database() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().database();
    }

    public AzureSqlDWLinkedService withDatabase(Object database) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withDatabase(database);
        return this;
    }

    public Object encrypt() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().encrypt();
    }

    public AzureSqlDWLinkedService withEncrypt(Object encrypt) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withEncrypt(encrypt);
        return this;
    }

    public Object trustServerCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().trustServerCertificate();
    }

    public AzureSqlDWLinkedService withTrustServerCertificate(Object trustServerCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withTrustServerCertificate(trustServerCertificate);
        return this;
    }

    public Object hostnameInCertificate() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().hostnameInCertificate();
    }

    public AzureSqlDWLinkedService withHostnameInCertificate(Object hostnameInCertificate) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withHostnameInCertificate(hostnameInCertificate);
        return this;
    }

    public Object applicationIntent() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().applicationIntent();
    }

    public AzureSqlDWLinkedService withApplicationIntent(Object applicationIntent) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withApplicationIntent(applicationIntent);
        return this;
    }

    public Object connectTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectTimeout();
    }

    public AzureSqlDWLinkedService withConnectTimeout(Object connectTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectTimeout(connectTimeout);
        return this;
    }

    public Object connectRetryCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryCount();
    }

    public AzureSqlDWLinkedService withConnectRetryCount(Object connectRetryCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryCount(connectRetryCount);
        return this;
    }

    public Object connectRetryInterval() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().connectRetryInterval();
    }

    public AzureSqlDWLinkedService withConnectRetryInterval(Object connectRetryInterval) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withConnectRetryInterval(connectRetryInterval);
        return this;
    }

    public Object loadBalanceTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().loadBalanceTimeout();
    }

    public AzureSqlDWLinkedService withLoadBalanceTimeout(Object loadBalanceTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withLoadBalanceTimeout(loadBalanceTimeout);
        return this;
    }

    public Object commandTimeout() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().commandTimeout();
    }

    public AzureSqlDWLinkedService withCommandTimeout(Object commandTimeout) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withCommandTimeout(commandTimeout);
        return this;
    }

    public Object integratedSecurity() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().integratedSecurity();
    }

    public AzureSqlDWLinkedService withIntegratedSecurity(Object integratedSecurity) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withIntegratedSecurity(integratedSecurity);
        return this;
    }

    public Object failoverPartner() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().failoverPartner();
    }

    public AzureSqlDWLinkedService withFailoverPartner(Object failoverPartner) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withFailoverPartner(failoverPartner);
        return this;
    }

    public Object maxPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().maxPoolSize();
    }

    public AzureSqlDWLinkedService withMaxPoolSize(Object maxPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMaxPoolSize(maxPoolSize);
        return this;
    }

    public Object minPoolSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().minPoolSize();
    }

    public AzureSqlDWLinkedService withMinPoolSize(Object minPoolSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMinPoolSize(minPoolSize);
        return this;
    }

    public Object multipleActiveResultSets() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multipleActiveResultSets();
    }

    public AzureSqlDWLinkedService withMultipleActiveResultSets(Object multipleActiveResultSets) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultipleActiveResultSets(multipleActiveResultSets);
        return this;
    }

    public Object multiSubnetFailover() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().multiSubnetFailover();
    }

    public AzureSqlDWLinkedService withMultiSubnetFailover(Object multiSubnetFailover) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withMultiSubnetFailover(multiSubnetFailover);
        return this;
    }

    public Object packetSize() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().packetSize();
    }

    public AzureSqlDWLinkedService withPacketSize(Object packetSize) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPacketSize(packetSize);
        return this;
    }

    public Object pooling() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().pooling();
    }

    public AzureSqlDWLinkedService withPooling(Object pooling) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new AzureSqlDWLinkedServiceTypeProperties();
        }
        this.innerTypeProperties().withPooling(pooling);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model AzureSqlDWLinkedService"));
        }
        this.innerTypeProperties().validate();
        if (this.connectVia() != null) {
            this.connectVia().validate();
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("version", this.version());
        jsonWriter.writeJsonField("connectVia", (JsonSerializable)this.connectVia());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureSqlDWLinkedService fromJson(JsonReader jsonReader) throws IOException {
        return (AzureSqlDWLinkedService)jsonReader.readObject(reader -> {
            AzureSqlDWLinkedService deserializedAzureSqlDWLinkedService = new AzureSqlDWLinkedService();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("version".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.withVersion(reader.getString());
                    continue;
                }
                if ("connectVia".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.withConnectVia(IntegrationRuntimeReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.withDescription(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedAzureSqlDWLinkedService.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedAzureSqlDWLinkedService.withAnnotations(annotations);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.innerTypeProperties = AzureSqlDWLinkedServiceTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureSqlDWLinkedService.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureSqlDWLinkedService.withAdditionalProperties(additionalProperties);
            return deserializedAzureSqlDWLinkedService;
        });
    }
}

