/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.AzureDatabricksDeltaLakeImportCommand;
import com.azure.resourcemanager.datafactory.models.CopySink;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class AzureDatabricksDeltaLakeSink
extends CopySink {
    private String type = "AzureDatabricksDeltaLakeSink";
    private Object preCopyScript;
    private AzureDatabricksDeltaLakeImportCommand importSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public AzureDatabricksDeltaLakeSink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public AzureDatabricksDeltaLakeImportCommand importSettings() {
        return this.importSettings;
    }

    public AzureDatabricksDeltaLakeSink withImportSettings(AzureDatabricksDeltaLakeImportCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public AzureDatabricksDeltaLakeSink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.importSettings() != null) {
            this.importSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        if (this.writeBatchSize() != null) {
            jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        }
        if (this.writeBatchTimeout() != null) {
            jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        }
        if (this.sinkRetryCount() != null) {
            jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        }
        if (this.sinkRetryWait() != null) {
            jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        }
        if (this.maxConcurrentConnections() != null) {
            jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        }
        if (this.disableMetricsCollection() != null) {
            jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        }
        jsonWriter.writeStringField("type", this.type);
        if (this.preCopyScript != null) {
            jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        }
        jsonWriter.writeJsonField("importSettings", (JsonSerializable)this.importSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static AzureDatabricksDeltaLakeSink fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDatabricksDeltaLakeSink)jsonReader.readObject(reader -> {
            AzureDatabricksDeltaLakeSink deserializedAzureDatabricksDeltaLakeSink = new AzureDatabricksDeltaLakeSink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("importSettings".equals(fieldName)) {
                    deserializedAzureDatabricksDeltaLakeSink.importSettings = AzureDatabricksDeltaLakeImportCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedAzureDatabricksDeltaLakeSink.withAdditionalProperties(additionalProperties);
            return deserializedAzureDatabricksDeltaLakeSink;
        });
    }
}

