/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.datafactory.fluent.GlobalParametersClient;
import com.azure.resourcemanager.datafactory.fluent.models.GlobalParameterResourceInner;
import com.azure.resourcemanager.datafactory.implementation.DataFactoryManagementClientImpl;
import com.azure.resourcemanager.datafactory.models.GlobalParameterListResponse;
import reactor.core.publisher.Mono;

public final class GlobalParametersClientImpl
implements GlobalParametersClient {
    private final GlobalParametersService service;
    private final DataFactoryManagementClientImpl client;
    private static final ClientLogger LOGGER = new ClientLogger(GlobalParametersClientImpl.class);

    GlobalParametersClientImpl(DataFactoryManagementClientImpl client) {
        this.service = (GlobalParametersService)RestProxy.create(GlobalParametersService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GlobalParameterResourceInner>> listByFactorySinglePageAsync(String resourceGroupName, String factoryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactory(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<GlobalParameterResourceInner> listByFactoryAsync(String resourceGroupName, String factoryName) {
        return new PagedFlux(() -> this.listByFactorySinglePageAsync(resourceGroupName, factoryName), nextLink -> this.listByFactoryNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GlobalParameterResourceInner> listByFactorySinglePage(String resourceGroupName, String factoryName) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GlobalParameterListResponse> res = this.service.listByFactorySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GlobalParameterResourceInner> listByFactorySinglePage(String resourceGroupName, String factoryName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GlobalParameterListResponse> res = this.service.listByFactorySync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, this.client.getApiVersion(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null);
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GlobalParameterResourceInner> listByFactory(String resourceGroupName, String factoryName) {
        return new PagedIterable(() -> this.listByFactorySinglePage(resourceGroupName, factoryName), nextLink -> this.listByFactoryNextSinglePage((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<GlobalParameterResourceInner> listByFactory(String resourceGroupName, String factoryName, Context context) {
        return new PagedIterable(() -> this.listByFactorySinglePage(resourceGroupName, factoryName, context), nextLink -> this.listByFactoryNextSinglePage((String)nextLink, context));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GlobalParameterResourceInner>> getWithResponseAsync(String resourceGroupName, String factoryName, String globalParameterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GlobalParameterResourceInner> getAsync(String resourceGroupName, String factoryName, String globalParameterName) {
        return this.getWithResponseAsync(resourceGroupName, factoryName, globalParameterName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GlobalParameterResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GlobalParameterResourceInner> getWithResponse(String resourceGroupName, String factoryName, String globalParameterName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.getSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GlobalParameterResourceInner get(String resourceGroupName, String factoryName, String globalParameterName) {
        return (GlobalParameterResourceInner)((Object)this.getWithResponse(resourceGroupName, factoryName, globalParameterName, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<GlobalParameterResourceInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String factoryName, String globalParameterName, GlobalParameterResourceInner defaultParameter) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        if (defaultParameter == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        defaultParameter.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), defaultParameter, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<GlobalParameterResourceInner> createOrUpdateAsync(String resourceGroupName, String factoryName, String globalParameterName, GlobalParameterResourceInner defaultParameter) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, factoryName, globalParameterName, defaultParameter).flatMap(res -> Mono.justOrEmpty((Object)((Object)((GlobalParameterResourceInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<GlobalParameterResourceInner> createOrUpdateWithResponse(String resourceGroupName, String factoryName, String globalParameterName, GlobalParameterResourceInner defaultParameter, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        if (defaultParameter == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter defaultParameter is required and cannot be null."));
        }
        defaultParameter.validate();
        String accept = "application/json";
        return this.service.createOrUpdateSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), defaultParameter, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public GlobalParameterResourceInner createOrUpdate(String resourceGroupName, String factoryName, String globalParameterName, GlobalParameterResourceInner defaultParameter) {
        return (GlobalParameterResourceInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, factoryName, globalParameterName, defaultParameter, Context.NONE).getValue());
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String factoryName, String globalParameterName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String factoryName, String globalParameterName) {
        return this.deleteWithResponseAsync(resourceGroupName, factoryName, globalParameterName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String factoryName, String globalParameterName, Context context) {
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (factoryName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter factoryName is required and cannot be null."));
        }
        if (globalParameterName == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter globalParameterName is required and cannot be null."));
        }
        String accept = "application/json";
        return this.service.deleteSync(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, factoryName, globalParameterName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String factoryName, String globalParameterName) {
        this.deleteWithResponse(resourceGroupName, factoryName, globalParameterName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<GlobalParameterResourceInner>> listByFactoryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listByFactoryNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GlobalParameterResourceInner> listByFactoryNextSinglePage(String nextLink) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GlobalParameterListResponse> res = this.service.listByFactoryNextSync(nextLink, this.client.getEndpoint(), "application/json", Context.NONE);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private PagedResponse<GlobalParameterResourceInner> listByFactoryNextSinglePage(String nextLink, Context context) {
        if (nextLink == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        Response<GlobalParameterListResponse> res = this.service.listByFactoryNextSync(nextLink, this.client.getEndpoint(), "application/json", context);
        return new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((GlobalParameterListResponse)res.getValue()).value(), ((GlobalParameterListResponse)res.getValue()).nextLink(), null);
    }

    @Host(value="{$host}")
    @ServiceInterface(name="DataFactoryManagemen")
    public static interface GlobalParametersService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GlobalParameterListResponse>> listByFactory(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GlobalParameterListResponse> listByFactorySync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @QueryParam(value="api-version") String var5, @HeaderParam(value="Accept") String var6, Context var7);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GlobalParameterResourceInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GlobalParameterResourceInner> getSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GlobalParameterResourceInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GlobalParameterResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GlobalParameterResourceInner> createOrUpdateSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") GlobalParameterResourceInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/globalParameters/{globalParameterName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<Void> deleteSync(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="factoryName") String var4, @PathParam(value="globalParameterName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<GlobalParameterListResponse>> listByFactoryNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Response<GlobalParameterListResponse> listByFactoryNextSync(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

