/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import com.azure.resourcemanager.datafactory.models.PipelineFolder;
import com.azure.resourcemanager.datafactory.models.PipelinePolicy;
import com.azure.resourcemanager.datafactory.models.VariableSpecification;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class Pipeline
implements JsonSerializable<Pipeline> {
    private String description;
    private List<Activity> activities;
    private Map<String, ParameterSpecification> parameters;
    private Map<String, VariableSpecification> variables;
    private Integer concurrency;
    private List<Object> annotations;
    private Map<String, Object> runDimensions;
    private PipelineFolder folder;
    private PipelinePolicy policy;

    public String description() {
        return this.description;
    }

    public Pipeline withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<Activity> activities() {
        return this.activities;
    }

    public Pipeline withActivities(List<Activity> activities) {
        this.activities = activities;
        return this;
    }

    public Map<String, ParameterSpecification> parameters() {
        return this.parameters;
    }

    public Pipeline withParameters(Map<String, ParameterSpecification> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Map<String, VariableSpecification> variables() {
        return this.variables;
    }

    public Pipeline withVariables(Map<String, VariableSpecification> variables) {
        this.variables = variables;
        return this;
    }

    public Integer concurrency() {
        return this.concurrency;
    }

    public Pipeline withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return this;
    }

    public List<Object> annotations() {
        return this.annotations;
    }

    public Pipeline withAnnotations(List<Object> annotations) {
        this.annotations = annotations;
        return this;
    }

    public Map<String, Object> runDimensions() {
        return this.runDimensions;
    }

    public Pipeline withRunDimensions(Map<String, Object> runDimensions) {
        this.runDimensions = runDimensions;
        return this;
    }

    public PipelineFolder folder() {
        return this.folder;
    }

    public Pipeline withFolder(PipelineFolder folder) {
        this.folder = folder;
        return this;
    }

    public PipelinePolicy policy() {
        return this.policy;
    }

    public Pipeline withPolicy(PipelinePolicy policy) {
        this.policy = policy;
        return this;
    }

    public void validate() {
        if (this.activities() != null) {
            this.activities().forEach(e -> e.validate());
        }
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.variables() != null) {
            this.variables().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("activities", this.activities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeMapField("variables", this.variables, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("concurrency", (Number)this.concurrency);
        jsonWriter.writeArrayField("annotations", this.annotations, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeMapField("runDimensions", this.runDimensions, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder);
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy);
        return jsonWriter.writeEndObject();
    }

    public static Pipeline fromJson(JsonReader jsonReader) throws IOException {
        return (Pipeline)jsonReader.readObject(reader -> {
            Pipeline deserializedPipeline = new Pipeline();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedPipeline.description = reader.getString();
                    continue;
                }
                if ("activities".equals(fieldName)) {
                    List activities;
                    deserializedPipeline.activities = activities = reader.readArray(reader1 -> Activity.fromJson(reader1));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters;
                    deserializedPipeline.parameters = parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    continue;
                }
                if ("variables".equals(fieldName)) {
                    Map variables;
                    deserializedPipeline.variables = variables = reader.readMap(reader1 -> VariableSpecification.fromJson(reader1));
                    continue;
                }
                if ("concurrency".equals(fieldName)) {
                    deserializedPipeline.concurrency = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations;
                    deserializedPipeline.annotations = annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("runDimensions".equals(fieldName)) {
                    Map runDimensions;
                    deserializedPipeline.runDimensions = runDimensions = reader.readMap(reader1 -> reader1.readUntyped());
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedPipeline.folder = PipelineFolder.fromJson(reader);
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedPipeline.policy = PipelinePolicy.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPipeline;
        });
    }
}

