/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.MongoDbAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class MongoDbLinkedServiceTypeProperties
implements JsonSerializable<MongoDbLinkedServiceTypeProperties> {
    private Object server;
    private MongoDbAuthenticationType authenticationType;
    private Object databaseName;
    private Object username;
    private SecretBase password;
    private Object authSource;
    private Object port;
    private Object enableSsl;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(MongoDbLinkedServiceTypeProperties.class);

    public Object server() {
        return this.server;
    }

    public MongoDbLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public MongoDbAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public MongoDbLinkedServiceTypeProperties withAuthenticationType(MongoDbAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object databaseName() {
        return this.databaseName;
    }

    public MongoDbLinkedServiceTypeProperties withDatabaseName(Object databaseName) {
        this.databaseName = databaseName;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public MongoDbLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public MongoDbLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object authSource() {
        return this.authSource;
    }

    public MongoDbLinkedServiceTypeProperties withAuthSource(Object authSource) {
        this.authSource = authSource;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public MongoDbLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public MongoDbLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public MongoDbLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public MongoDbLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model MongoDbLinkedServiceTypeProperties"));
        }
        if (this.databaseName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property databaseName in model MongoDbLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeUntypedField("databaseName", this.databaseName);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.authSource != null) {
            jsonWriter.writeUntypedField("authSource", this.authSource);
        }
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static MongoDbLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (MongoDbLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            MongoDbLinkedServiceTypeProperties deserializedMongoDbLinkedServiceTypeProperties = new MongoDbLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("databaseName".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.databaseName = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.authenticationType = MongoDbAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authSource".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.authSource = reader.readUntyped();
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedMongoDbLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedMongoDbLinkedServiceTypeProperties;
        });
    }
}

