/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntime;
import java.io.IOException;

public final class IntegrationRuntimeResourceInner
extends SubResource {
    private IntegrationRuntime properties;
    private String name;
    private String type;
    private String etag;
    private static final ClientLogger LOGGER = new ClientLogger(IntegrationRuntimeResourceInner.class);

    public IntegrationRuntime properties() {
        return this.properties;
    }

    public IntegrationRuntimeResourceInner withProperties(IntegrationRuntime properties) {
        this.properties = properties;
        return this;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public String etag() {
        return this.etag;
    }

    public IntegrationRuntimeResourceInner withId(String id) {
        super.withId(id);
        return this;
    }

    public void validate() {
        if (this.properties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property properties in model IntegrationRuntimeResourceInner"));
        }
        this.properties().validate();
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeResourceInner fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeResourceInner)((Object)jsonReader.readObject(reader -> {
            IntegrationRuntimeResourceInner deserializedIntegrationRuntimeResourceInner = new IntegrationRuntimeResourceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedIntegrationRuntimeResourceInner.withId(reader.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedIntegrationRuntimeResourceInner.properties = IntegrationRuntime.fromJson(reader);
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedIntegrationRuntimeResourceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedIntegrationRuntimeResourceInner.type = reader.getString();
                    continue;
                }
                if ("etag".equals(fieldName)) {
                    deserializedIntegrationRuntimeResourceInner.etag = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedIntegrationRuntimeResourceInner;
        }));
    }
}

