/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.HBaseAuthenticationType;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class HBaseLinkedServiceTypeProperties
implements JsonSerializable<HBaseLinkedServiceTypeProperties> {
    private Object host;
    private Object port;
    private Object httpPath;
    private HBaseAuthenticationType authenticationType;
    private Object username;
    private SecretBase password;
    private Object enableSsl;
    private Object trustedCertPath;
    private Object allowHostnameCNMismatch;
    private Object allowSelfSignedServerCert;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(HBaseLinkedServiceTypeProperties.class);

    public Object host() {
        return this.host;
    }

    public HBaseLinkedServiceTypeProperties withHost(Object host) {
        this.host = host;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public HBaseLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public Object httpPath() {
        return this.httpPath;
    }

    public HBaseLinkedServiceTypeProperties withHttpPath(Object httpPath) {
        this.httpPath = httpPath;
        return this;
    }

    public HBaseAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public HBaseLinkedServiceTypeProperties withAuthenticationType(HBaseAuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public HBaseLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public HBaseLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object enableSsl() {
        return this.enableSsl;
    }

    public HBaseLinkedServiceTypeProperties withEnableSsl(Object enableSsl) {
        this.enableSsl = enableSsl;
        return this;
    }

    public Object trustedCertPath() {
        return this.trustedCertPath;
    }

    public HBaseLinkedServiceTypeProperties withTrustedCertPath(Object trustedCertPath) {
        this.trustedCertPath = trustedCertPath;
        return this;
    }

    public Object allowHostnameCNMismatch() {
        return this.allowHostnameCNMismatch;
    }

    public HBaseLinkedServiceTypeProperties withAllowHostnameCNMismatch(Object allowHostnameCNMismatch) {
        this.allowHostnameCNMismatch = allowHostnameCNMismatch;
        return this;
    }

    public Object allowSelfSignedServerCert() {
        return this.allowSelfSignedServerCert;
    }

    public HBaseLinkedServiceTypeProperties withAllowSelfSignedServerCert(Object allowSelfSignedServerCert) {
        this.allowSelfSignedServerCert = allowSelfSignedServerCert;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public HBaseLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.host() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property host in model HBaseLinkedServiceTypeProperties"));
        }
        if (this.authenticationType() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property authenticationType in model HBaseLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("host", this.host);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        if (this.httpPath != null) {
            jsonWriter.writeUntypedField("httpPath", this.httpPath);
        }
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.enableSsl != null) {
            jsonWriter.writeUntypedField("enableSsl", this.enableSsl);
        }
        if (this.trustedCertPath != null) {
            jsonWriter.writeUntypedField("trustedCertPath", this.trustedCertPath);
        }
        if (this.allowHostnameCNMismatch != null) {
            jsonWriter.writeUntypedField("allowHostNameCNMismatch", this.allowHostnameCNMismatch);
        }
        if (this.allowSelfSignedServerCert != null) {
            jsonWriter.writeUntypedField("allowSelfSignedServerCert", this.allowSelfSignedServerCert);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static HBaseLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (HBaseLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            HBaseLinkedServiceTypeProperties deserializedHBaseLinkedServiceTypeProperties = new HBaseLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("host".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.host = reader.readUntyped();
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.authenticationType = HBaseAuthenticationType.fromString(reader.getString());
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("httpPath".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.httpPath = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("enableSsl".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.enableSsl = reader.readUntyped();
                    continue;
                }
                if ("trustedCertPath".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.trustedCertPath = reader.readUntyped();
                    continue;
                }
                if ("allowHostNameCNMismatch".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.allowHostnameCNMismatch = reader.readUntyped();
                    continue;
                }
                if ("allowSelfSignedServerCert".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.allowSelfSignedServerCert = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedHBaseLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHBaseLinkedServiceTypeProperties;
        });
    }
}

