/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AzureDataLakeAnalyticsLinkedServiceTypeProperties
implements JsonSerializable<AzureDataLakeAnalyticsLinkedServiceTypeProperties> {
    private Object accountName;
    private Object servicePrincipalId;
    private SecretBase servicePrincipalKey;
    private Object tenant;
    private Object subscriptionId;
    private Object resourceGroupName;
    private Object dataLakeAnalyticsUri;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AzureDataLakeAnalyticsLinkedServiceTypeProperties.class);

    public Object accountName() {
        return this.accountName;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withAccountName(Object accountName) {
        this.accountName = accountName;
        return this;
    }

    public Object servicePrincipalId() {
        return this.servicePrincipalId;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withServicePrincipalId(Object servicePrincipalId) {
        this.servicePrincipalId = servicePrincipalId;
        return this;
    }

    public SecretBase servicePrincipalKey() {
        return this.servicePrincipalKey;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withServicePrincipalKey(SecretBase servicePrincipalKey) {
        this.servicePrincipalKey = servicePrincipalKey;
        return this;
    }

    public Object tenant() {
        return this.tenant;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withTenant(Object tenant) {
        this.tenant = tenant;
        return this;
    }

    public Object subscriptionId() {
        return this.subscriptionId;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withSubscriptionId(Object subscriptionId) {
        this.subscriptionId = subscriptionId;
        return this;
    }

    public Object resourceGroupName() {
        return this.resourceGroupName;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withResourceGroupName(Object resourceGroupName) {
        this.resourceGroupName = resourceGroupName;
        return this;
    }

    public Object dataLakeAnalyticsUri() {
        return this.dataLakeAnalyticsUri;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withDataLakeAnalyticsUri(Object dataLakeAnalyticsUri) {
        this.dataLakeAnalyticsUri = dataLakeAnalyticsUri;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AzureDataLakeAnalyticsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.accountName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accountName in model AzureDataLakeAnalyticsLinkedServiceTypeProperties"));
        }
        if (this.servicePrincipalKey() != null) {
            this.servicePrincipalKey().validate();
        }
        if (this.tenant() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property tenant in model AzureDataLakeAnalyticsLinkedServiceTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("accountName", this.accountName);
        jsonWriter.writeUntypedField("tenant", this.tenant);
        if (this.servicePrincipalId != null) {
            jsonWriter.writeUntypedField("servicePrincipalId", this.servicePrincipalId);
        }
        jsonWriter.writeJsonField("servicePrincipalKey", (JsonSerializable)this.servicePrincipalKey);
        if (this.subscriptionId != null) {
            jsonWriter.writeUntypedField("subscriptionId", this.subscriptionId);
        }
        if (this.resourceGroupName != null) {
            jsonWriter.writeUntypedField("resourceGroupName", this.resourceGroupName);
        }
        if (this.dataLakeAnalyticsUri != null) {
            jsonWriter.writeUntypedField("dataLakeAnalyticsUri", this.dataLakeAnalyticsUri);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AzureDataLakeAnalyticsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AzureDataLakeAnalyticsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AzureDataLakeAnalyticsLinkedServiceTypeProperties deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties = new AzureDataLakeAnalyticsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("accountName".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.accountName = reader.readUntyped();
                    continue;
                }
                if ("tenant".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.tenant = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalId".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.servicePrincipalId = reader.readUntyped();
                    continue;
                }
                if ("servicePrincipalKey".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.servicePrincipalKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("subscriptionId".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.subscriptionId = reader.readUntyped();
                    continue;
                }
                if ("resourceGroupName".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.resourceGroupName = reader.readUntyped();
                    continue;
                }
                if ("dataLakeAnalyticsUri".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.dataLakeAnalyticsUri = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAzureDataLakeAnalyticsLinkedServiceTypeProperties;
        });
    }
}

