/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AmazonRedshiftLinkedServiceTypeProperties
implements JsonSerializable<AmazonRedshiftLinkedServiceTypeProperties> {
    private Object server;
    private Object username;
    private SecretBase password;
    private Object database;
    private Object port;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AmazonRedshiftLinkedServiceTypeProperties.class);

    public Object server() {
        return this.server;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withServer(Object server) {
        this.server = server;
        return this;
    }

    public Object username() {
        return this.username;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withUsername(Object username) {
        this.username = username;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    public Object database() {
        return this.database;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withDatabase(Object database) {
        this.database = database;
        return this;
    }

    public Object port() {
        return this.port;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withPort(Object port) {
        this.port = port;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonRedshiftLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.server() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property server in model AmazonRedshiftLinkedServiceTypeProperties"));
        }
        if (this.password() != null) {
            this.password().validate();
        }
        if (this.database() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property database in model AmazonRedshiftLinkedServiceTypeProperties"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("server", this.server);
        jsonWriter.writeUntypedField("database", this.database);
        if (this.username != null) {
            jsonWriter.writeUntypedField("username", this.username);
        }
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        if (this.port != null) {
            jsonWriter.writeUntypedField("port", this.port);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AmazonRedshiftLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonRedshiftLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AmazonRedshiftLinkedServiceTypeProperties deserializedAmazonRedshiftLinkedServiceTypeProperties = new AmazonRedshiftLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("server".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.server = reader.readUntyped();
                    continue;
                }
                if ("database".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.database = reader.readUntyped();
                    continue;
                }
                if ("username".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.username = reader.readUntyped();
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("port".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.port = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAmazonRedshiftLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonRedshiftLinkedServiceTypeProperties;
        });
    }
}

