/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import java.io.IOException;

public final class AmazonMwsLinkedServiceTypeProperties
implements JsonSerializable<AmazonMwsLinkedServiceTypeProperties> {
    private Object endpoint;
    private Object marketplaceId;
    private Object sellerId;
    private SecretBase mwsAuthToken;
    private Object accessKeyId;
    private SecretBase secretKey;
    private Object useEncryptedEndpoints;
    private Object useHostVerification;
    private Object usePeerVerification;
    private String encryptedCredential;
    private static final ClientLogger LOGGER = new ClientLogger(AmazonMwsLinkedServiceTypeProperties.class);

    public Object endpoint() {
        return this.endpoint;
    }

    public AmazonMwsLinkedServiceTypeProperties withEndpoint(Object endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    public Object marketplaceId() {
        return this.marketplaceId;
    }

    public AmazonMwsLinkedServiceTypeProperties withMarketplaceId(Object marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    public Object sellerId() {
        return this.sellerId;
    }

    public AmazonMwsLinkedServiceTypeProperties withSellerId(Object sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    public SecretBase mwsAuthToken() {
        return this.mwsAuthToken;
    }

    public AmazonMwsLinkedServiceTypeProperties withMwsAuthToken(SecretBase mwsAuthToken) {
        this.mwsAuthToken = mwsAuthToken;
        return this;
    }

    public Object accessKeyId() {
        return this.accessKeyId;
    }

    public AmazonMwsLinkedServiceTypeProperties withAccessKeyId(Object accessKeyId) {
        this.accessKeyId = accessKeyId;
        return this;
    }

    public SecretBase secretKey() {
        return this.secretKey;
    }

    public AmazonMwsLinkedServiceTypeProperties withSecretKey(SecretBase secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public Object useEncryptedEndpoints() {
        return this.useEncryptedEndpoints;
    }

    public AmazonMwsLinkedServiceTypeProperties withUseEncryptedEndpoints(Object useEncryptedEndpoints) {
        this.useEncryptedEndpoints = useEncryptedEndpoints;
        return this;
    }

    public Object useHostVerification() {
        return this.useHostVerification;
    }

    public AmazonMwsLinkedServiceTypeProperties withUseHostVerification(Object useHostVerification) {
        this.useHostVerification = useHostVerification;
        return this;
    }

    public Object usePeerVerification() {
        return this.usePeerVerification;
    }

    public AmazonMwsLinkedServiceTypeProperties withUsePeerVerification(Object usePeerVerification) {
        this.usePeerVerification = usePeerVerification;
        return this;
    }

    public String encryptedCredential() {
        return this.encryptedCredential;
    }

    public AmazonMwsLinkedServiceTypeProperties withEncryptedCredential(String encryptedCredential) {
        this.encryptedCredential = encryptedCredential;
        return this;
    }

    public void validate() {
        if (this.endpoint() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property endpoint in model AmazonMwsLinkedServiceTypeProperties"));
        }
        if (this.marketplaceId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property marketplaceId in model AmazonMwsLinkedServiceTypeProperties"));
        }
        if (this.sellerId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sellerId in model AmazonMwsLinkedServiceTypeProperties"));
        }
        if (this.mwsAuthToken() != null) {
            this.mwsAuthToken().validate();
        }
        if (this.accessKeyId() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property accessKeyId in model AmazonMwsLinkedServiceTypeProperties"));
        }
        if (this.secretKey() != null) {
            this.secretKey().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("endpoint", this.endpoint);
        jsonWriter.writeUntypedField("marketplaceID", this.marketplaceId);
        jsonWriter.writeUntypedField("sellerID", this.sellerId);
        jsonWriter.writeUntypedField("accessKeyId", this.accessKeyId);
        jsonWriter.writeJsonField("mwsAuthToken", (JsonSerializable)this.mwsAuthToken);
        jsonWriter.writeJsonField("secretKey", (JsonSerializable)this.secretKey);
        if (this.useEncryptedEndpoints != null) {
            jsonWriter.writeUntypedField("useEncryptedEndpoints", this.useEncryptedEndpoints);
        }
        if (this.useHostVerification != null) {
            jsonWriter.writeUntypedField("useHostVerification", this.useHostVerification);
        }
        if (this.usePeerVerification != null) {
            jsonWriter.writeUntypedField("usePeerVerification", this.usePeerVerification);
        }
        jsonWriter.writeStringField("encryptedCredential", this.encryptedCredential);
        return jsonWriter.writeEndObject();
    }

    public static AmazonMwsLinkedServiceTypeProperties fromJson(JsonReader jsonReader) throws IOException {
        return (AmazonMwsLinkedServiceTypeProperties)jsonReader.readObject(reader -> {
            AmazonMwsLinkedServiceTypeProperties deserializedAmazonMwsLinkedServiceTypeProperties = new AmazonMwsLinkedServiceTypeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("endpoint".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.endpoint = reader.readUntyped();
                    continue;
                }
                if ("marketplaceID".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.marketplaceId = reader.readUntyped();
                    continue;
                }
                if ("sellerID".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.sellerId = reader.readUntyped();
                    continue;
                }
                if ("accessKeyId".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.accessKeyId = reader.readUntyped();
                    continue;
                }
                if ("mwsAuthToken".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.mwsAuthToken = SecretBase.fromJson(reader);
                    continue;
                }
                if ("secretKey".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.secretKey = SecretBase.fromJson(reader);
                    continue;
                }
                if ("useEncryptedEndpoints".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.useEncryptedEndpoints = reader.readUntyped();
                    continue;
                }
                if ("useHostVerification".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.useHostVerification = reader.readUntyped();
                    continue;
                }
                if ("usePeerVerification".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.usePeerVerification = reader.readUntyped();
                    continue;
                }
                if ("encryptedCredential".equals(fieldName)) {
                    deserializedAmazonMwsLinkedServiceTypeProperties.encryptedCredential = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAmazonMwsLinkedServiceTypeProperties;
        });
    }
}

