/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CompressionReadSettings;
import com.azure.resourcemanager.datafactory.models.FormatReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class XmlReadSettings
extends FormatReadSettings {
    private String type = "XmlReadSettings";
    private CompressionReadSettings compressionProperties;
    private Object validationMode;
    private Object detectDataType;
    private Object namespaces;
    private Object namespacePrefixes;

    @Override
    public String type() {
        return this.type;
    }

    public CompressionReadSettings compressionProperties() {
        return this.compressionProperties;
    }

    public XmlReadSettings withCompressionProperties(CompressionReadSettings compressionProperties) {
        this.compressionProperties = compressionProperties;
        return this;
    }

    public Object validationMode() {
        return this.validationMode;
    }

    public XmlReadSettings withValidationMode(Object validationMode) {
        this.validationMode = validationMode;
        return this;
    }

    public Object detectDataType() {
        return this.detectDataType;
    }

    public XmlReadSettings withDetectDataType(Object detectDataType) {
        this.detectDataType = detectDataType;
        return this;
    }

    public Object namespaces() {
        return this.namespaces;
    }

    public XmlReadSettings withNamespaces(Object namespaces) {
        this.namespaces = namespaces;
        return this;
    }

    public Object namespacePrefixes() {
        return this.namespacePrefixes;
    }

    public XmlReadSettings withNamespacePrefixes(Object namespacePrefixes) {
        this.namespacePrefixes = namespacePrefixes;
        return this;
    }

    @Override
    public void validate() {
        if (this.compressionProperties() != null) {
            this.compressionProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("compressionProperties", (JsonSerializable)this.compressionProperties);
        jsonWriter.writeUntypedField("validationMode", this.validationMode);
        jsonWriter.writeUntypedField("detectDataType", this.detectDataType);
        jsonWriter.writeUntypedField("namespaces", this.namespaces);
        jsonWriter.writeUntypedField("namespacePrefixes", this.namespacePrefixes);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static XmlReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (XmlReadSettings)jsonReader.readObject(reader -> {
            XmlReadSettings deserializedXmlReadSettings = new XmlReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedXmlReadSettings.type = reader.getString();
                    continue;
                }
                if ("compressionProperties".equals(fieldName)) {
                    deserializedXmlReadSettings.compressionProperties = CompressionReadSettings.fromJson(reader);
                    continue;
                }
                if ("validationMode".equals(fieldName)) {
                    deserializedXmlReadSettings.validationMode = reader.readUntyped();
                    continue;
                }
                if ("detectDataType".equals(fieldName)) {
                    deserializedXmlReadSettings.detectDataType = reader.readUntyped();
                    continue;
                }
                if ("namespaces".equals(fieldName)) {
                    deserializedXmlReadSettings.namespaces = reader.readUntyped();
                    continue;
                }
                if ("namespacePrefixes".equals(fieldName)) {
                    deserializedXmlReadSettings.namespacePrefixes = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedXmlReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedXmlReadSettings;
        });
    }
}

