/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SecretBase;
import com.azure.resourcemanager.datafactory.models.WebAuthenticationType;
import com.azure.resourcemanager.datafactory.models.WebLinkedServiceTypeProperties;
import java.io.IOException;

public final class WebClientCertificateAuthentication
extends WebLinkedServiceTypeProperties {
    private WebAuthenticationType authenticationType = WebAuthenticationType.CLIENT_CERTIFICATE;
    private SecretBase pfx;
    private SecretBase password;
    private static final ClientLogger LOGGER = new ClientLogger(WebClientCertificateAuthentication.class);

    @Override
    public WebAuthenticationType authenticationType() {
        return this.authenticationType;
    }

    public SecretBase pfx() {
        return this.pfx;
    }

    public WebClientCertificateAuthentication withPfx(SecretBase pfx) {
        this.pfx = pfx;
        return this;
    }

    public SecretBase password() {
        return this.password;
    }

    public WebClientCertificateAuthentication withPassword(SecretBase password) {
        this.password = password;
        return this;
    }

    @Override
    public WebClientCertificateAuthentication withUrl(Object url) {
        super.withUrl(url);
        return this;
    }

    @Override
    public void validate() {
        if (this.pfx() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property pfx in model WebClientCertificateAuthentication"));
        }
        this.pfx().validate();
        if (this.password() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property password in model WebClientCertificateAuthentication"));
        }
        this.password().validate();
        if (this.url() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property url in model WebClientCertificateAuthentication"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("url", this.url());
        jsonWriter.writeJsonField("pfx", (JsonSerializable)this.pfx);
        jsonWriter.writeJsonField("password", (JsonSerializable)this.password);
        jsonWriter.writeStringField("authenticationType", this.authenticationType == null ? null : this.authenticationType.toString());
        return jsonWriter.writeEndObject();
    }

    public static WebClientCertificateAuthentication fromJson(JsonReader jsonReader) throws IOException {
        return (WebClientCertificateAuthentication)jsonReader.readObject(reader -> {
            WebClientCertificateAuthentication deserializedWebClientCertificateAuthentication = new WebClientCertificateAuthentication();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("url".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.withUrl(reader.readUntyped());
                    continue;
                }
                if ("pfx".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.pfx = SecretBase.fromJson(reader);
                    continue;
                }
                if ("password".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.password = SecretBase.fromJson(reader);
                    continue;
                }
                if ("authenticationType".equals(fieldName)) {
                    deserializedWebClientCertificateAuthentication.authenticationType = WebAuthenticationType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebClientCertificateAuthentication;
        });
    }
}

