/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisEnvironmentReference;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadata;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataType;
import com.azure.resourcemanager.datafactory.models.SsisParameter;
import java.io.IOException;
import java.util.List;

public final class SsisProject
extends SsisObjectMetadata {
    private SsisObjectMetadataType type = SsisObjectMetadataType.PROJECT;
    private Long folderId;
    private Long version;
    private List<SsisEnvironmentReference> environmentRefs;
    private List<SsisParameter> parameters;

    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    public Long folderId() {
        return this.folderId;
    }

    public SsisProject withFolderId(Long folderId) {
        this.folderId = folderId;
        return this;
    }

    public Long version() {
        return this.version;
    }

    public SsisProject withVersion(Long version) {
        this.version = version;
        return this;
    }

    public List<SsisEnvironmentReference> environmentRefs() {
        return this.environmentRefs;
    }

    public SsisProject withEnvironmentRefs(List<SsisEnvironmentReference> environmentRefs) {
        this.environmentRefs = environmentRefs;
        return this;
    }

    public List<SsisParameter> parameters() {
        return this.parameters;
    }

    public SsisProject withParameters(List<SsisParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public SsisProject withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public SsisProject withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SsisProject withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        if (this.environmentRefs() != null) {
            this.environmentRefs().forEach(e -> e.validate());
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", (Number)this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeNumberField("folderId", (Number)this.folderId);
        jsonWriter.writeNumberField("version", (Number)this.version);
        jsonWriter.writeArrayField("environmentRefs", this.environmentRefs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SsisProject fromJson(JsonReader jsonReader) throws IOException {
        return (SsisProject)jsonReader.readObject(reader -> {
            SsisProject deserializedSsisProject = new SsisProject();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSsisProject.withId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSsisProject.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSsisProject.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisProject.type = SsisObjectMetadataType.fromString(reader.getString());
                    continue;
                }
                if ("folderId".equals(fieldName)) {
                    deserializedSsisProject.folderId = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("version".equals(fieldName)) {
                    deserializedSsisProject.version = (Long)reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if ("environmentRefs".equals(fieldName)) {
                    List environmentRefs;
                    deserializedSsisProject.environmentRefs = environmentRefs = reader.readArray(reader1 -> SsisEnvironmentReference.fromJson(reader1));
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedSsisProject.parameters = parameters = reader.readArray(reader1 -> SsisParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisProject;
        });
    }
}

