/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadata;
import com.azure.resourcemanager.datafactory.models.SsisObjectMetadataType;
import java.io.IOException;

public final class SsisFolder
extends SsisObjectMetadata {
    private SsisObjectMetadataType type = SsisObjectMetadataType.FOLDER;

    @Override
    public SsisObjectMetadataType type() {
        return this.type;
    }

    @Override
    public SsisFolder withId(Long id) {
        super.withId(id);
        return this;
    }

    @Override
    public SsisFolder withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SsisFolder withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("id", (Number)this.id());
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static SsisFolder fromJson(JsonReader jsonReader) throws IOException {
        return (SsisFolder)jsonReader.readObject(reader -> {
            SsisFolder deserializedSsisFolder = new SsisFolder();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSsisFolder.withId((Long)reader.getNullable(JsonReader::getLong));
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSsisFolder.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSsisFolder.withDescription(reader.getString());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSsisFolder.type = SsisObjectMetadataType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSsisFolder;
        });
    }
}

