/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.SqlServerStoredProcedureActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class SqlServerStoredProcedureActivity
extends ExecutionActivity {
    private String type = "SqlServerStoredProcedure";
    private SqlServerStoredProcedureActivityTypeProperties innerTypeProperties = new SqlServerStoredProcedureActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(SqlServerStoredProcedureActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    SqlServerStoredProcedureActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public SqlServerStoredProcedureActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public SqlServerStoredProcedureActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object storedProcedureName() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storedProcedureName();
    }

    public SqlServerStoredProcedureActivity withStoredProcedureName(Object storedProcedureName) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerStoredProcedureActivityTypeProperties();
        }
        this.innerTypeProperties().withStoredProcedureName(storedProcedureName);
        return this;
    }

    public Object storedProcedureParameters() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().storedProcedureParameters();
    }

    public SqlServerStoredProcedureActivity withStoredProcedureParameters(Object storedProcedureParameters) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new SqlServerStoredProcedureActivityTypeProperties();
        }
        this.innerTypeProperties().withStoredProcedureParameters(storedProcedureParameters);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model SqlServerStoredProcedureActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SqlServerStoredProcedureActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SqlServerStoredProcedureActivity fromJson(JsonReader jsonReader) throws IOException {
        return (SqlServerStoredProcedureActivity)jsonReader.readObject(reader -> {
            SqlServerStoredProcedureActivity deserializedSqlServerStoredProcedureActivity = new SqlServerStoredProcedureActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedSqlServerStoredProcedureActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedSqlServerStoredProcedureActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.innerTypeProperties = SqlServerStoredProcedureActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSqlServerStoredProcedureActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSqlServerStoredProcedureActivity.withAdditionalProperties(additionalProperties);
            return deserializedSqlServerStoredProcedureActivity;
        });
    }
}

