/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.SparkConfigurationReferenceType;
import java.io.IOException;

public final class SparkConfigurationParametrizationReference
implements JsonSerializable<SparkConfigurationParametrizationReference> {
    private SparkConfigurationReferenceType type;
    private Object referenceName;
    private static final ClientLogger LOGGER = new ClientLogger(SparkConfigurationParametrizationReference.class);

    public SparkConfigurationReferenceType type() {
        return this.type;
    }

    public SparkConfigurationParametrizationReference withType(SparkConfigurationReferenceType type) {
        this.type = type;
        return this;
    }

    public Object referenceName() {
        return this.referenceName;
    }

    public SparkConfigurationParametrizationReference withReferenceName(Object referenceName) {
        this.referenceName = referenceName;
        return this;
    }

    public void validate() {
        if (this.type() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property type in model SparkConfigurationParametrizationReference"));
        }
        if (this.referenceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property referenceName in model SparkConfigurationParametrizationReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeUntypedField("referenceName", this.referenceName);
        return jsonWriter.writeEndObject();
    }

    public static SparkConfigurationParametrizationReference fromJson(JsonReader jsonReader) throws IOException {
        return (SparkConfigurationParametrizationReference)jsonReader.readObject(reader -> {
            SparkConfigurationParametrizationReference deserializedSparkConfigurationParametrizationReference = new SparkConfigurationParametrizationReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedSparkConfigurationParametrizationReference.type = SparkConfigurationReferenceType.fromString(reader.getString());
                    continue;
                }
                if ("referenceName".equals(fieldName)) {
                    deserializedSparkConfigurationParametrizationReference.referenceName = reader.readUntyped();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSparkConfigurationParametrizationReference;
        });
    }
}

