/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.SnowflakeImportCopyCommand;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class SnowflakeV2Sink
extends CopySink {
    private String type = "SnowflakeV2Sink";
    private Object preCopyScript;
    private SnowflakeImportCopyCommand importSettings;

    @Override
    public String type() {
        return this.type;
    }

    public Object preCopyScript() {
        return this.preCopyScript;
    }

    public SnowflakeV2Sink withPreCopyScript(Object preCopyScript) {
        this.preCopyScript = preCopyScript;
        return this;
    }

    public SnowflakeImportCopyCommand importSettings() {
        return this.importSettings;
    }

    public SnowflakeV2Sink withImportSettings(SnowflakeImportCopyCommand importSettings) {
        this.importSettings = importSettings;
        return this;
    }

    @Override
    public SnowflakeV2Sink withWriteBatchSize(Object writeBatchSize) {
        super.withWriteBatchSize(writeBatchSize);
        return this;
    }

    @Override
    public SnowflakeV2Sink withWriteBatchTimeout(Object writeBatchTimeout) {
        super.withWriteBatchTimeout(writeBatchTimeout);
        return this;
    }

    @Override
    public SnowflakeV2Sink withSinkRetryCount(Object sinkRetryCount) {
        super.withSinkRetryCount(sinkRetryCount);
        return this;
    }

    @Override
    public SnowflakeV2Sink withSinkRetryWait(Object sinkRetryWait) {
        super.withSinkRetryWait(sinkRetryWait);
        return this;
    }

    @Override
    public SnowflakeV2Sink withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public SnowflakeV2Sink withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.importSettings() != null) {
            this.importSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("writeBatchSize", this.writeBatchSize());
        jsonWriter.writeUntypedField("writeBatchTimeout", this.writeBatchTimeout());
        jsonWriter.writeUntypedField("sinkRetryCount", this.sinkRetryCount());
        jsonWriter.writeUntypedField("sinkRetryWait", this.sinkRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("preCopyScript", this.preCopyScript);
        jsonWriter.writeJsonField("importSettings", (JsonSerializable)this.importSettings);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static SnowflakeV2Sink fromJson(JsonReader jsonReader) throws IOException {
        return (SnowflakeV2Sink)jsonReader.readObject(reader -> {
            SnowflakeV2Sink deserializedSnowflakeV2Sink = new SnowflakeV2Sink();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("writeBatchSize".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withWriteBatchSize(reader.readUntyped());
                    continue;
                }
                if ("writeBatchTimeout".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withWriteBatchTimeout(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryCount".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withSinkRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sinkRetryWait".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withSinkRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.type = reader.getString();
                    continue;
                }
                if ("preCopyScript".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.preCopyScript = reader.readUntyped();
                    continue;
                }
                if ("importSettings".equals(fieldName)) {
                    deserializedSnowflakeV2Sink.importSettings = SnowflakeImportCopyCommand.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedSnowflakeV2Sink.withAdditionalProperties(additionalProperties);
            return deserializedSnowflakeV2Sink;
        });
    }
}

