/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.OraclePartitionSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class OracleSource
extends CopySource {
    private String type = "OracleSource";
    private Object oracleReaderQuery;
    private Object queryTimeout;
    private Object partitionOption;
    private OraclePartitionSettings partitionSettings;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object oracleReaderQuery() {
        return this.oracleReaderQuery;
    }

    public OracleSource withOracleReaderQuery(Object oracleReaderQuery) {
        this.oracleReaderQuery = oracleReaderQuery;
        return this;
    }

    public Object queryTimeout() {
        return this.queryTimeout;
    }

    public OracleSource withQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object partitionOption() {
        return this.partitionOption;
    }

    public OracleSource withPartitionOption(Object partitionOption) {
        this.partitionOption = partitionOption;
        return this;
    }

    public OraclePartitionSettings partitionSettings() {
        return this.partitionSettings;
    }

    public OracleSource withPartitionSettings(OraclePartitionSettings partitionSettings) {
        this.partitionSettings = partitionSettings;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public OracleSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public OracleSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public OracleSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public OracleSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public OracleSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.partitionSettings() != null) {
            this.partitionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("oracleReaderQuery", this.oracleReaderQuery);
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        jsonWriter.writeUntypedField("partitionOption", this.partitionOption);
        jsonWriter.writeJsonField("partitionSettings", (JsonSerializable)this.partitionSettings);
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static OracleSource fromJson(JsonReader jsonReader) throws IOException {
        return (OracleSource)jsonReader.readObject(reader -> {
            OracleSource deserializedOracleSource = new OracleSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedOracleSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedOracleSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedOracleSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedOracleSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedOracleSource.type = reader.getString();
                    continue;
                }
                if ("oracleReaderQuery".equals(fieldName)) {
                    deserializedOracleSource.oracleReaderQuery = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedOracleSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("partitionOption".equals(fieldName)) {
                    deserializedOracleSource.partitionOption = reader.readUntyped();
                    continue;
                }
                if ("partitionSettings".equals(fieldName)) {
                    deserializedOracleSource.partitionSettings = OraclePartitionSettings.fromJson(reader);
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedOracleSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedOracleSource.withAdditionalProperties(additionalProperties);
            return deserializedOracleSource;
        });
    }
}

