/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.BlobEventsTrigger;
import com.azure.resourcemanager.datafactory.models.BlobTrigger;
import com.azure.resourcemanager.datafactory.models.CustomEventsTrigger;
import com.azure.resourcemanager.datafactory.models.ScheduleTrigger;
import com.azure.resourcemanager.datafactory.models.Trigger;
import com.azure.resourcemanager.datafactory.models.TriggerPipelineReference;
import com.azure.resourcemanager.datafactory.models.TriggerRuntimeState;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MultiplePipelineTrigger
extends Trigger {
    private String type = "MultiplePipelineTrigger";
    private List<TriggerPipelineReference> pipelines;

    @Override
    public String type() {
        return this.type;
    }

    public List<TriggerPipelineReference> pipelines() {
        return this.pipelines;
    }

    public MultiplePipelineTrigger withPipelines(List<TriggerPipelineReference> pipelines) {
        this.pipelines = pipelines;
        return this;
    }

    @Override
    public MultiplePipelineTrigger withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public MultiplePipelineTrigger withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public void validate() {
        if (this.pipelines() != null) {
            this.pipelines().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("pipelines", this.pipelines, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MultiplePipelineTrigger fromJson(JsonReader jsonReader) throws IOException {
        return (MultiplePipelineTrigger)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MultiplePipelineTrigger multiplePipelineTrigger;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ScheduleTrigger".equals(discriminatorValue)) {
                    multiplePipelineTrigger = ScheduleTrigger.fromJson(readerToUse.reset());
                    return multiplePipelineTrigger;
                }
                if ("BlobTrigger".equals(discriminatorValue)) {
                    multiplePipelineTrigger = BlobTrigger.fromJson(readerToUse.reset());
                    return multiplePipelineTrigger;
                }
                if ("BlobEventsTrigger".equals(discriminatorValue)) {
                    multiplePipelineTrigger = BlobEventsTrigger.fromJson(readerToUse.reset());
                    return multiplePipelineTrigger;
                }
                if ("CustomEventsTrigger".equals(discriminatorValue)) {
                    multiplePipelineTrigger = CustomEventsTrigger.fromJson(readerToUse.reset());
                    return multiplePipelineTrigger;
                }
                multiplePipelineTrigger = MultiplePipelineTrigger.fromJsonKnownDiscriminator(readerToUse.reset());
                return multiplePipelineTrigger;
            }
        });
    }

    static MultiplePipelineTrigger fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MultiplePipelineTrigger)jsonReader.readObject(reader -> {
            MultiplePipelineTrigger deserializedMultiplePipelineTrigger = new MultiplePipelineTrigger();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("description".equals(fieldName)) {
                    deserializedMultiplePipelineTrigger.withDescription(reader.getString());
                    continue;
                }
                if ("runtimeState".equals(fieldName)) {
                    deserializedMultiplePipelineTrigger.withRuntimeState(TriggerRuntimeState.fromString(reader.getString()));
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedMultiplePipelineTrigger.withAnnotations(annotations);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedMultiplePipelineTrigger.type = reader.getString();
                    continue;
                }
                if ("pipelines".equals(fieldName)) {
                    List pipelines;
                    deserializedMultiplePipelineTrigger.pipelines = pipelines = reader.readArray(reader1 -> TriggerPipelineReference.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMultiplePipelineTrigger.withAdditionalProperties(additionalProperties);
            return deserializedMultiplePipelineTrigger;
        });
    }
}

