/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ConnectionStateProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedPrivateEndpoint
implements JsonSerializable<ManagedPrivateEndpoint> {
    private ConnectionStateProperties connectionState;
    private List<String> fqdns;
    private String groupId;
    private Boolean isReserved;
    private String privateLinkResourceId;
    private String provisioningState;
    private Map<String, Object> additionalProperties;

    public ConnectionStateProperties connectionState() {
        return this.connectionState;
    }

    public ManagedPrivateEndpoint withConnectionState(ConnectionStateProperties connectionState) {
        this.connectionState = connectionState;
        return this;
    }

    public List<String> fqdns() {
        return this.fqdns;
    }

    public ManagedPrivateEndpoint withFqdns(List<String> fqdns) {
        this.fqdns = fqdns;
        return this;
    }

    public String groupId() {
        return this.groupId;
    }

    public ManagedPrivateEndpoint withGroupId(String groupId) {
        this.groupId = groupId;
        return this;
    }

    public Boolean isReserved() {
        return this.isReserved;
    }

    public String privateLinkResourceId() {
        return this.privateLinkResourceId;
    }

    public ManagedPrivateEndpoint withPrivateLinkResourceId(String privateLinkResourceId) {
        this.privateLinkResourceId = privateLinkResourceId;
        return this;
    }

    public String provisioningState() {
        return this.provisioningState;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ManagedPrivateEndpoint withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.connectionState() != null) {
            this.connectionState().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("connectionState", (JsonSerializable)this.connectionState);
        jsonWriter.writeArrayField("fqdns", this.fqdns, (writer, element) -> writer.writeString(element));
        jsonWriter.writeStringField("groupId", this.groupId);
        jsonWriter.writeStringField("privateLinkResourceId", this.privateLinkResourceId);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedPrivateEndpoint fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedPrivateEndpoint)jsonReader.readObject(reader -> {
            ManagedPrivateEndpoint deserializedManagedPrivateEndpoint = new ManagedPrivateEndpoint();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("connectionState".equals(fieldName)) {
                    deserializedManagedPrivateEndpoint.connectionState = ConnectionStateProperties.fromJson(reader);
                    continue;
                }
                if ("fqdns".equals(fieldName)) {
                    List fqdns;
                    deserializedManagedPrivateEndpoint.fqdns = fqdns = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("groupId".equals(fieldName)) {
                    deserializedManagedPrivateEndpoint.groupId = reader.getString();
                    continue;
                }
                if ("isReserved".equals(fieldName)) {
                    deserializedManagedPrivateEndpoint.isReserved = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("privateLinkResourceId".equals(fieldName)) {
                    deserializedManagedPrivateEndpoint.privateLinkResourceId = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedManagedPrivateEndpoint.provisioningState = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedPrivateEndpoint.additionalProperties = additionalProperties;
            return deserializedManagedPrivateEndpoint;
        });
    }
}

