/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeError;
import com.azure.resourcemanager.datafactory.models.ManagedIntegrationRuntimeNodeStatus;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ManagedIntegrationRuntimeNode
implements JsonSerializable<ManagedIntegrationRuntimeNode> {
    private String nodeId;
    private ManagedIntegrationRuntimeNodeStatus status;
    private List<ManagedIntegrationRuntimeError> errors;
    private Map<String, Object> additionalProperties;

    public String nodeId() {
        return this.nodeId;
    }

    public ManagedIntegrationRuntimeNodeStatus status() {
        return this.status;
    }

    public List<ManagedIntegrationRuntimeError> errors() {
        return this.errors;
    }

    public ManagedIntegrationRuntimeNode withErrors(List<ManagedIntegrationRuntimeError> errors) {
        this.errors = errors;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public ManagedIntegrationRuntimeNode withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.errors() != null) {
            this.errors().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("errors", this.errors, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ManagedIntegrationRuntimeNode fromJson(JsonReader jsonReader) throws IOException {
        return (ManagedIntegrationRuntimeNode)jsonReader.readObject(reader -> {
            ManagedIntegrationRuntimeNode deserializedManagedIntegrationRuntimeNode = new ManagedIntegrationRuntimeNode();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("nodeId".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeNode.nodeId = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedManagedIntegrationRuntimeNode.status = ManagedIntegrationRuntimeNodeStatus.fromString(reader.getString());
                    continue;
                }
                if ("errors".equals(fieldName)) {
                    List errors;
                    deserializedManagedIntegrationRuntimeNode.errors = errors = reader.readArray(reader1 -> ManagedIntegrationRuntimeError.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedManagedIntegrationRuntimeNode.additionalProperties = additionalProperties;
            return deserializedManagedIntegrationRuntimeNode;
        });
    }
}

