/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.LinkedIntegrationRuntimeType;
import com.azure.resourcemanager.datafactory.models.SecureString;
import java.io.IOException;

public final class LinkedIntegrationRuntimeKeyAuthorization
extends LinkedIntegrationRuntimeType {
    private String authorizationType = "Key";
    private SecureString key;
    private static final ClientLogger LOGGER = new ClientLogger(LinkedIntegrationRuntimeKeyAuthorization.class);

    @Override
    public String authorizationType() {
        return this.authorizationType;
    }

    public SecureString key() {
        return this.key;
    }

    public LinkedIntegrationRuntimeKeyAuthorization withKey(SecureString key) {
        this.key = key;
        return this;
    }

    @Override
    public void validate() {
        if (this.key() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property key in model LinkedIntegrationRuntimeKeyAuthorization"));
        }
        this.key().validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("key", (JsonSerializable)this.key);
        jsonWriter.writeStringField("authorizationType", this.authorizationType);
        return jsonWriter.writeEndObject();
    }

    public static LinkedIntegrationRuntimeKeyAuthorization fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedIntegrationRuntimeKeyAuthorization)jsonReader.readObject(reader -> {
            LinkedIntegrationRuntimeKeyAuthorization deserializedLinkedIntegrationRuntimeKeyAuthorization = new LinkedIntegrationRuntimeKeyAuthorization();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("key".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeKeyAuthorization.key = SecureString.fromJson(reader);
                    continue;
                }
                if ("authorizationType".equals(fieldName)) {
                    deserializedLinkedIntegrationRuntimeKeyAuthorization.authorizationType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedIntegrationRuntimeKeyAuthorization;
        });
    }
}

