/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.StoreReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class LakeHouseReadSettings
extends StoreReadSettings {
    private String type = "LakeHouseReadSettings";
    private Object recursive;
    private Object wildcardFolderPath;
    private Object wildcardFileName;
    private Object fileListPath;
    private Object enablePartitionDiscovery;
    private Object partitionRootPath;
    private Object deleteFilesAfterCompletion;
    private Object modifiedDatetimeStart;
    private Object modifiedDatetimeEnd;

    @Override
    public String type() {
        return this.type;
    }

    public Object recursive() {
        return this.recursive;
    }

    public LakeHouseReadSettings withRecursive(Object recursive) {
        this.recursive = recursive;
        return this;
    }

    public Object wildcardFolderPath() {
        return this.wildcardFolderPath;
    }

    public LakeHouseReadSettings withWildcardFolderPath(Object wildcardFolderPath) {
        this.wildcardFolderPath = wildcardFolderPath;
        return this;
    }

    public Object wildcardFileName() {
        return this.wildcardFileName;
    }

    public LakeHouseReadSettings withWildcardFileName(Object wildcardFileName) {
        this.wildcardFileName = wildcardFileName;
        return this;
    }

    public Object fileListPath() {
        return this.fileListPath;
    }

    public LakeHouseReadSettings withFileListPath(Object fileListPath) {
        this.fileListPath = fileListPath;
        return this;
    }

    public Object enablePartitionDiscovery() {
        return this.enablePartitionDiscovery;
    }

    public LakeHouseReadSettings withEnablePartitionDiscovery(Object enablePartitionDiscovery) {
        this.enablePartitionDiscovery = enablePartitionDiscovery;
        return this;
    }

    public Object partitionRootPath() {
        return this.partitionRootPath;
    }

    public LakeHouseReadSettings withPartitionRootPath(Object partitionRootPath) {
        this.partitionRootPath = partitionRootPath;
        return this;
    }

    public Object deleteFilesAfterCompletion() {
        return this.deleteFilesAfterCompletion;
    }

    public LakeHouseReadSettings withDeleteFilesAfterCompletion(Object deleteFilesAfterCompletion) {
        this.deleteFilesAfterCompletion = deleteFilesAfterCompletion;
        return this;
    }

    public Object modifiedDatetimeStart() {
        return this.modifiedDatetimeStart;
    }

    public LakeHouseReadSettings withModifiedDatetimeStart(Object modifiedDatetimeStart) {
        this.modifiedDatetimeStart = modifiedDatetimeStart;
        return this;
    }

    public Object modifiedDatetimeEnd() {
        return this.modifiedDatetimeEnd;
    }

    public LakeHouseReadSettings withModifiedDatetimeEnd(Object modifiedDatetimeEnd) {
        this.modifiedDatetimeEnd = modifiedDatetimeEnd;
        return this;
    }

    @Override
    public LakeHouseReadSettings withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public LakeHouseReadSettings withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("recursive", this.recursive);
        jsonWriter.writeUntypedField("wildcardFolderPath", this.wildcardFolderPath);
        jsonWriter.writeUntypedField("wildcardFileName", this.wildcardFileName);
        jsonWriter.writeUntypedField("fileListPath", this.fileListPath);
        jsonWriter.writeUntypedField("enablePartitionDiscovery", this.enablePartitionDiscovery);
        jsonWriter.writeUntypedField("partitionRootPath", this.partitionRootPath);
        jsonWriter.writeUntypedField("deleteFilesAfterCompletion", this.deleteFilesAfterCompletion);
        jsonWriter.writeUntypedField("modifiedDatetimeStart", this.modifiedDatetimeStart);
        jsonWriter.writeUntypedField("modifiedDatetimeEnd", this.modifiedDatetimeEnd);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static LakeHouseReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (LakeHouseReadSettings)jsonReader.readObject(reader -> {
            LakeHouseReadSettings deserializedLakeHouseReadSettings = new LakeHouseReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.type = reader.getString();
                    continue;
                }
                if ("recursive".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.recursive = reader.readUntyped();
                    continue;
                }
                if ("wildcardFolderPath".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.wildcardFolderPath = reader.readUntyped();
                    continue;
                }
                if ("wildcardFileName".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.wildcardFileName = reader.readUntyped();
                    continue;
                }
                if ("fileListPath".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.fileListPath = reader.readUntyped();
                    continue;
                }
                if ("enablePartitionDiscovery".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.enablePartitionDiscovery = reader.readUntyped();
                    continue;
                }
                if ("partitionRootPath".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.partitionRootPath = reader.readUntyped();
                    continue;
                }
                if ("deleteFilesAfterCompletion".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.deleteFilesAfterCompletion = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeStart".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.modifiedDatetimeStart = reader.readUntyped();
                    continue;
                }
                if ("modifiedDatetimeEnd".equals(fieldName)) {
                    deserializedLakeHouseReadSettings.modifiedDatetimeEnd = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedLakeHouseReadSettings.withAdditionalProperties(additionalProperties);
            return deserializedLakeHouseReadSettings;
        });
    }
}

