/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.IntegrationRuntimeSsisCatalogPricingTier;
import com.azure.resourcemanager.datafactory.models.SecureString;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class IntegrationRuntimeSsisCatalogInfo
implements JsonSerializable<IntegrationRuntimeSsisCatalogInfo> {
    private String catalogServerEndpoint;
    private String catalogAdminUsername;
    private SecureString catalogAdminPassword;
    private IntegrationRuntimeSsisCatalogPricingTier catalogPricingTier;
    private String dualStandbyPairName;
    private Map<String, Object> additionalProperties;

    public String catalogServerEndpoint() {
        return this.catalogServerEndpoint;
    }

    public IntegrationRuntimeSsisCatalogInfo withCatalogServerEndpoint(String catalogServerEndpoint) {
        this.catalogServerEndpoint = catalogServerEndpoint;
        return this;
    }

    public String catalogAdminUsername() {
        return this.catalogAdminUsername;
    }

    public IntegrationRuntimeSsisCatalogInfo withCatalogAdminUsername(String catalogAdminUsername) {
        this.catalogAdminUsername = catalogAdminUsername;
        return this;
    }

    public SecureString catalogAdminPassword() {
        return this.catalogAdminPassword;
    }

    public IntegrationRuntimeSsisCatalogInfo withCatalogAdminPassword(SecureString catalogAdminPassword) {
        this.catalogAdminPassword = catalogAdminPassword;
        return this;
    }

    public IntegrationRuntimeSsisCatalogPricingTier catalogPricingTier() {
        return this.catalogPricingTier;
    }

    public IntegrationRuntimeSsisCatalogInfo withCatalogPricingTier(IntegrationRuntimeSsisCatalogPricingTier catalogPricingTier) {
        this.catalogPricingTier = catalogPricingTier;
        return this;
    }

    public String dualStandbyPairName() {
        return this.dualStandbyPairName;
    }

    public IntegrationRuntimeSsisCatalogInfo withDualStandbyPairName(String dualStandbyPairName) {
        this.dualStandbyPairName = dualStandbyPairName;
        return this;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public IntegrationRuntimeSsisCatalogInfo withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
        if (this.catalogAdminPassword() != null) {
            this.catalogAdminPassword().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("catalogServerEndpoint", this.catalogServerEndpoint);
        jsonWriter.writeStringField("catalogAdminUserName", this.catalogAdminUsername);
        jsonWriter.writeJsonField("catalogAdminPassword", (JsonSerializable)this.catalogAdminPassword);
        jsonWriter.writeStringField("catalogPricingTier", this.catalogPricingTier == null ? null : this.catalogPricingTier.toString());
        jsonWriter.writeStringField("dualStandbyPairName", this.dualStandbyPairName);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static IntegrationRuntimeSsisCatalogInfo fromJson(JsonReader jsonReader) throws IOException {
        return (IntegrationRuntimeSsisCatalogInfo)jsonReader.readObject(reader -> {
            IntegrationRuntimeSsisCatalogInfo deserializedIntegrationRuntimeSsisCatalogInfo = new IntegrationRuntimeSsisCatalogInfo();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("catalogServerEndpoint".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisCatalogInfo.catalogServerEndpoint = reader.getString();
                    continue;
                }
                if ("catalogAdminUserName".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisCatalogInfo.catalogAdminUsername = reader.getString();
                    continue;
                }
                if ("catalogAdminPassword".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisCatalogInfo.catalogAdminPassword = SecureString.fromJson(reader);
                    continue;
                }
                if ("catalogPricingTier".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisCatalogInfo.catalogPricingTier = IntegrationRuntimeSsisCatalogPricingTier.fromString(reader.getString());
                    continue;
                }
                if ("dualStandbyPairName".equals(fieldName)) {
                    deserializedIntegrationRuntimeSsisCatalogInfo.dualStandbyPairName = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedIntegrationRuntimeSsisCatalogInfo.additionalProperties = additionalProperties;
            return deserializedIntegrationRuntimeSsisCatalogInfo;
        });
    }
}

