/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TabularSource;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class ImpalaSource
extends TabularSource {
    private String type = "ImpalaSource";
    private Object query;

    @Override
    public String type() {
        return this.type;
    }

    public Object query() {
        return this.query;
    }

    public ImpalaSource withQuery(Object query) {
        this.query = query;
        return this;
    }

    @Override
    public ImpalaSource withQueryTimeout(Object queryTimeout) {
        super.withQueryTimeout(queryTimeout);
        return this;
    }

    @Override
    public ImpalaSource withAdditionalColumns(Object additionalColumns) {
        super.withAdditionalColumns(additionalColumns);
        return this;
    }

    @Override
    public ImpalaSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public ImpalaSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public ImpalaSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public ImpalaSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout());
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("query", this.query);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ImpalaSource fromJson(JsonReader jsonReader) throws IOException {
        return (ImpalaSource)jsonReader.readObject(reader -> {
            ImpalaSource deserializedImpalaSource = new ImpalaSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedImpalaSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedImpalaSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedImpalaSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedImpalaSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedImpalaSource.withQueryTimeout(reader.readUntyped());
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedImpalaSource.withAdditionalColumns(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedImpalaSource.type = reader.getString();
                    continue;
                }
                if ("query".equals(fieldName)) {
                    deserializedImpalaSource.query = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedImpalaSource.withAdditionalProperties(additionalProperties);
            return deserializedImpalaSource;
        });
    }
}

