/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.HttpDatasetTypeProperties;
import com.azure.resourcemanager.datafactory.models.Dataset;
import com.azure.resourcemanager.datafactory.models.DatasetCompression;
import com.azure.resourcemanager.datafactory.models.DatasetFolder;
import com.azure.resourcemanager.datafactory.models.DatasetStorageFormat;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.ParameterSpecification;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HttpDataset
extends Dataset {
    private String type = "HttpFile";
    private HttpDatasetTypeProperties innerTypeProperties;
    private static final ClientLogger LOGGER = new ClientLogger(HttpDataset.class);

    @Override
    public String type() {
        return this.type;
    }

    HttpDatasetTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HttpDataset withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HttpDataset withStructure(Object structure) {
        super.withStructure(structure);
        return this;
    }

    @Override
    public HttpDataset withSchema(Object schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public HttpDataset withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HttpDataset withParameters(Map<String, ParameterSpecification> parameters) {
        super.withParameters(parameters);
        return this;
    }

    @Override
    public HttpDataset withAnnotations(List<Object> annotations) {
        super.withAnnotations(annotations);
        return this;
    }

    @Override
    public HttpDataset withFolder(DatasetFolder folder) {
        super.withFolder(folder);
        return this;
    }

    public Object relativeUrl() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().relativeUrl();
    }

    public HttpDataset withRelativeUrl(Object relativeUrl) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withRelativeUrl(relativeUrl);
        return this;
    }

    public Object requestMethod() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestMethod();
    }

    public HttpDataset withRequestMethod(Object requestMethod) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestMethod(requestMethod);
        return this;
    }

    public Object requestBody() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().requestBody();
    }

    public HttpDataset withRequestBody(Object requestBody) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withRequestBody(requestBody);
        return this;
    }

    public Object additionalHeaders() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().additionalHeaders();
    }

    public HttpDataset withAdditionalHeaders(Object additionalHeaders) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withAdditionalHeaders(additionalHeaders);
        return this;
    }

    public DatasetStorageFormat format() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().format();
    }

    public HttpDataset withFormat(DatasetStorageFormat format) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withFormat(format);
        return this;
    }

    public DatasetCompression compression() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().compression();
    }

    public HttpDataset withCompression(DatasetCompression compression) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HttpDatasetTypeProperties();
        }
        this.innerTypeProperties().withCompression(compression);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() != null) {
            this.innerTypeProperties().validate();
        }
        if (this.linkedServiceName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property linkedServiceName in model HttpDataset"));
        }
        this.linkedServiceName().validate();
        if (this.parameters() != null) {
            this.parameters().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
        if (this.folder() != null) {
            this.folder().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeUntypedField("structure", this.structure());
        jsonWriter.writeUntypedField("schema", this.schema());
        jsonWriter.writeMapField("parameters", this.parameters(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("annotations", this.annotations(), (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeJsonField("folder", (JsonSerializable)this.folder());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HttpDataset fromJson(JsonReader jsonReader) throws IOException {
        return (HttpDataset)jsonReader.readObject(reader -> {
            HttpDataset deserializedHttpDataset = new HttpDataset();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHttpDataset.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHttpDataset.withDescription(reader.getString());
                    continue;
                }
                if ("structure".equals(fieldName)) {
                    deserializedHttpDataset.withStructure(reader.readUntyped());
                    continue;
                }
                if ("schema".equals(fieldName)) {
                    deserializedHttpDataset.withSchema(reader.readUntyped());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    Map parameters = reader.readMap(reader1 -> ParameterSpecification.fromJson(reader1));
                    deserializedHttpDataset.withParameters(parameters);
                    continue;
                }
                if ("annotations".equals(fieldName)) {
                    List annotations = reader.readArray(reader1 -> reader1.readUntyped());
                    deserializedHttpDataset.withAnnotations(annotations);
                    continue;
                }
                if ("folder".equals(fieldName)) {
                    deserializedHttpDataset.withFolder(DatasetFolder.fromJson(reader));
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHttpDataset.type = reader.getString();
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedHttpDataset.innerTypeProperties = HttpDatasetTypeProperties.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHttpDataset.withAdditionalProperties(additionalProperties);
            return deserializedHttpDataset;
        });
    }
}

