/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.HDInsightSparkActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.HDInsightActivityDebugInfoOption;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class HDInsightSparkActivity
extends ExecutionActivity {
    private String type = "HDInsightSpark";
    private HDInsightSparkActivityTypeProperties innerTypeProperties = new HDInsightSparkActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(HDInsightSparkActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    HDInsightSparkActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public HDInsightSparkActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public HDInsightSparkActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public HDInsightSparkActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public HDInsightSparkActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public HDInsightSparkActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public HDInsightSparkActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public HDInsightSparkActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public HDInsightSparkActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Object rootPath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().rootPath();
    }

    public HDInsightSparkActivity withRootPath(Object rootPath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withRootPath(rootPath);
        return this;
    }

    public Object entryFilePath() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().entryFilePath();
    }

    public HDInsightSparkActivity withEntryFilePath(Object entryFilePath) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withEntryFilePath(entryFilePath);
        return this;
    }

    public List<Object> arguments() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().arguments();
    }

    public HDInsightSparkActivity withArguments(List<Object> arguments) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withArguments(arguments);
        return this;
    }

    public HDInsightActivityDebugInfoOption getDebugInfo() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().getDebugInfo();
    }

    public HDInsightSparkActivity withGetDebugInfo(HDInsightActivityDebugInfoOption getDebugInfo) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withGetDebugInfo(getDebugInfo);
        return this;
    }

    public LinkedServiceReference sparkJobLinkedService() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkJobLinkedService();
    }

    public HDInsightSparkActivity withSparkJobLinkedService(LinkedServiceReference sparkJobLinkedService) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkJobLinkedService(sparkJobLinkedService);
        return this;
    }

    public String className() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().className();
    }

    public HDInsightSparkActivity withClassName(String className) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withClassName(className);
        return this;
    }

    public Object proxyUser() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().proxyUser();
    }

    public HDInsightSparkActivity withProxyUser(Object proxyUser) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withProxyUser(proxyUser);
        return this;
    }

    public Map<String, Object> sparkConfig() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sparkConfig();
    }

    public HDInsightSparkActivity withSparkConfig(Map<String, Object> sparkConfig) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new HDInsightSparkActivityTypeProperties();
        }
        this.innerTypeProperties().withSparkConfig(sparkConfig);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model HDInsightSparkActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model HDInsightSparkActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static HDInsightSparkActivity fromJson(JsonReader jsonReader) throws IOException {
        return (HDInsightSparkActivity)jsonReader.readObject(reader -> {
            HDInsightSparkActivity deserializedHDInsightSparkActivity = new HDInsightSparkActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedHDInsightSparkActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedHDInsightSparkActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.innerTypeProperties = HDInsightSparkActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedHDInsightSparkActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedHDInsightSparkActivity.withAdditionalProperties(additionalProperties);
            return deserializedHDInsightSparkActivity;
        });
    }
}

