/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.GitHubClientSecret;
import java.io.IOException;

public final class GitHubAccessTokenRequest
implements JsonSerializable<GitHubAccessTokenRequest> {
    private String gitHubAccessCode;
    private String gitHubClientId;
    private GitHubClientSecret gitHubClientSecret;
    private String gitHubAccessTokenBaseUrl;
    private static final ClientLogger LOGGER = new ClientLogger(GitHubAccessTokenRequest.class);

    public String gitHubAccessCode() {
        return this.gitHubAccessCode;
    }

    public GitHubAccessTokenRequest withGitHubAccessCode(String gitHubAccessCode) {
        this.gitHubAccessCode = gitHubAccessCode;
        return this;
    }

    public String gitHubClientId() {
        return this.gitHubClientId;
    }

    public GitHubAccessTokenRequest withGitHubClientId(String gitHubClientId) {
        this.gitHubClientId = gitHubClientId;
        return this;
    }

    public GitHubClientSecret gitHubClientSecret() {
        return this.gitHubClientSecret;
    }

    public GitHubAccessTokenRequest withGitHubClientSecret(GitHubClientSecret gitHubClientSecret) {
        this.gitHubClientSecret = gitHubClientSecret;
        return this;
    }

    public String gitHubAccessTokenBaseUrl() {
        return this.gitHubAccessTokenBaseUrl;
    }

    public GitHubAccessTokenRequest withGitHubAccessTokenBaseUrl(String gitHubAccessTokenBaseUrl) {
        this.gitHubAccessTokenBaseUrl = gitHubAccessTokenBaseUrl;
        return this;
    }

    public void validate() {
        if (this.gitHubAccessCode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property gitHubAccessCode in model GitHubAccessTokenRequest"));
        }
        if (this.gitHubClientSecret() != null) {
            this.gitHubClientSecret().validate();
        }
        if (this.gitHubAccessTokenBaseUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property gitHubAccessTokenBaseUrl in model GitHubAccessTokenRequest"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("gitHubAccessCode", this.gitHubAccessCode);
        jsonWriter.writeStringField("gitHubAccessTokenBaseUrl", this.gitHubAccessTokenBaseUrl);
        jsonWriter.writeStringField("gitHubClientId", this.gitHubClientId);
        jsonWriter.writeJsonField("gitHubClientSecret", (JsonSerializable)this.gitHubClientSecret);
        return jsonWriter.writeEndObject();
    }

    public static GitHubAccessTokenRequest fromJson(JsonReader jsonReader) throws IOException {
        return (GitHubAccessTokenRequest)jsonReader.readObject(reader -> {
            GitHubAccessTokenRequest deserializedGitHubAccessTokenRequest = new GitHubAccessTokenRequest();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("gitHubAccessCode".equals(fieldName)) {
                    deserializedGitHubAccessTokenRequest.gitHubAccessCode = reader.getString();
                    continue;
                }
                if ("gitHubAccessTokenBaseUrl".equals(fieldName)) {
                    deserializedGitHubAccessTokenRequest.gitHubAccessTokenBaseUrl = reader.getString();
                    continue;
                }
                if ("gitHubClientId".equals(fieldName)) {
                    deserializedGitHubAccessTokenRequest.gitHubClientId = reader.getString();
                    continue;
                }
                if ("gitHubClientSecret".equals(fieldName)) {
                    deserializedGitHubAccessTokenRequest.gitHubClientSecret = GitHubClientSecret.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGitHubAccessTokenRequest;
        });
    }
}

