/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ForEachActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.Activity;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.ControlActivity;
import com.azure.resourcemanager.datafactory.models.Expression;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class ForEachActivity
extends ControlActivity {
    private String type = "ForEach";
    private ForEachActivityTypeProperties innerTypeProperties = new ForEachActivityTypeProperties();
    private static final ClientLogger LOGGER = new ClientLogger(ForEachActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    ForEachActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    @Override
    public ForEachActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public ForEachActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public ForEachActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public ForEachActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public ForEachActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public ForEachActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public Boolean isSequential() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().isSequential();
    }

    public ForEachActivity withIsSequential(Boolean isSequential) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withIsSequential(isSequential);
        return this;
    }

    public Integer batchCount() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().batchCount();
    }

    public ForEachActivity withBatchCount(Integer batchCount) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withBatchCount(batchCount);
        return this;
    }

    public Expression items() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().items();
    }

    public ForEachActivity withItems(Expression items) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withItems(items);
        return this;
    }

    public List<Activity> activities() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().activities();
    }

    public ForEachActivity withActivities(List<Activity> activities) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new ForEachActivityTypeProperties();
        }
        this.innerTypeProperties().withActivities(activities);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model ForEachActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model ForEachActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static ForEachActivity fromJson(JsonReader jsonReader) throws IOException {
        return (ForEachActivity)jsonReader.readObject(reader -> {
            ForEachActivity deserializedForEachActivity = new ForEachActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedForEachActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedForEachActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedForEachActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedForEachActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedForEachActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedForEachActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedForEachActivity.innerTypeProperties = ForEachActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedForEachActivity.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedForEachActivity.withAdditionalProperties(additionalProperties);
            return deserializedForEachActivity;
        });
    }
}

