/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.MongoDbCursorMethodsProperties;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public final class CosmosDbMongoDbApiSource
extends CopySource {
    private String type = "CosmosDbMongoDbApiSource";
    private Object filter;
    private MongoDbCursorMethodsProperties cursorMethods;
    private Object batchSize;
    private Object queryTimeout;
    private Object additionalColumns;

    @Override
    public String type() {
        return this.type;
    }

    public Object filter() {
        return this.filter;
    }

    public CosmosDbMongoDbApiSource withFilter(Object filter) {
        this.filter = filter;
        return this;
    }

    public MongoDbCursorMethodsProperties cursorMethods() {
        return this.cursorMethods;
    }

    public CosmosDbMongoDbApiSource withCursorMethods(MongoDbCursorMethodsProperties cursorMethods) {
        this.cursorMethods = cursorMethods;
        return this;
    }

    public Object batchSize() {
        return this.batchSize;
    }

    public CosmosDbMongoDbApiSource withBatchSize(Object batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object queryTimeout() {
        return this.queryTimeout;
    }

    public CosmosDbMongoDbApiSource withQueryTimeout(Object queryTimeout) {
        this.queryTimeout = queryTimeout;
        return this;
    }

    public Object additionalColumns() {
        return this.additionalColumns;
    }

    public CosmosDbMongoDbApiSource withAdditionalColumns(Object additionalColumns) {
        this.additionalColumns = additionalColumns;
        return this;
    }

    @Override
    public CosmosDbMongoDbApiSource withSourceRetryCount(Object sourceRetryCount) {
        super.withSourceRetryCount(sourceRetryCount);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiSource withSourceRetryWait(Object sourceRetryWait) {
        super.withSourceRetryWait(sourceRetryWait);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiSource withMaxConcurrentConnections(Object maxConcurrentConnections) {
        super.withMaxConcurrentConnections(maxConcurrentConnections);
        return this;
    }

    @Override
    public CosmosDbMongoDbApiSource withDisableMetricsCollection(Object disableMetricsCollection) {
        super.withDisableMetricsCollection(disableMetricsCollection);
        return this;
    }

    @Override
    public void validate() {
        if (this.cursorMethods() != null) {
            this.cursorMethods().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeUntypedField("sourceRetryCount", this.sourceRetryCount());
        jsonWriter.writeUntypedField("sourceRetryWait", this.sourceRetryWait());
        jsonWriter.writeUntypedField("maxConcurrentConnections", this.maxConcurrentConnections());
        jsonWriter.writeUntypedField("disableMetricsCollection", this.disableMetricsCollection());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeUntypedField("filter", this.filter);
        jsonWriter.writeJsonField("cursorMethods", (JsonSerializable)this.cursorMethods);
        jsonWriter.writeUntypedField("batchSize", this.batchSize);
        jsonWriter.writeUntypedField("queryTimeout", this.queryTimeout);
        jsonWriter.writeUntypedField("additionalColumns", this.additionalColumns);
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CosmosDbMongoDbApiSource fromJson(JsonReader jsonReader) throws IOException {
        return (CosmosDbMongoDbApiSource)jsonReader.readObject(reader -> {
            CosmosDbMongoDbApiSource deserializedCosmosDbMongoDbApiSource = new CosmosDbMongoDbApiSource();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceRetryCount".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.withSourceRetryCount(reader.readUntyped());
                    continue;
                }
                if ("sourceRetryWait".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.withSourceRetryWait(reader.readUntyped());
                    continue;
                }
                if ("maxConcurrentConnections".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.withMaxConcurrentConnections(reader.readUntyped());
                    continue;
                }
                if ("disableMetricsCollection".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.withDisableMetricsCollection(reader.readUntyped());
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.type = reader.getString();
                    continue;
                }
                if ("filter".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.filter = reader.readUntyped();
                    continue;
                }
                if ("cursorMethods".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.cursorMethods = MongoDbCursorMethodsProperties.fromJson(reader);
                    continue;
                }
                if ("batchSize".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.batchSize = reader.readUntyped();
                    continue;
                }
                if ("queryTimeout".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.queryTimeout = reader.readUntyped();
                    continue;
                }
                if ("additionalColumns".equals(fieldName)) {
                    deserializedCosmosDbMongoDbApiSource.additionalColumns = reader.readUntyped();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCosmosDbMongoDbApiSource.withAdditionalProperties(additionalProperties);
            return deserializedCosmosDbMongoDbApiSource;
        });
    }
}

