/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.CopyActivityTypeProperties;
import com.azure.resourcemanager.datafactory.models.ActivityDependency;
import com.azure.resourcemanager.datafactory.models.ActivityOnInactiveMarkAs;
import com.azure.resourcemanager.datafactory.models.ActivityPolicy;
import com.azure.resourcemanager.datafactory.models.ActivityState;
import com.azure.resourcemanager.datafactory.models.CopySink;
import com.azure.resourcemanager.datafactory.models.CopySource;
import com.azure.resourcemanager.datafactory.models.DatasetReference;
import com.azure.resourcemanager.datafactory.models.ExecutionActivity;
import com.azure.resourcemanager.datafactory.models.LinkedServiceReference;
import com.azure.resourcemanager.datafactory.models.LogSettings;
import com.azure.resourcemanager.datafactory.models.LogStorageSettings;
import com.azure.resourcemanager.datafactory.models.RedirectIncompatibleRowSettings;
import com.azure.resourcemanager.datafactory.models.SkipErrorFile;
import com.azure.resourcemanager.datafactory.models.StagingSettings;
import com.azure.resourcemanager.datafactory.models.UserProperty;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class CopyActivity
extends ExecutionActivity {
    private String type = "Copy";
    private CopyActivityTypeProperties innerTypeProperties = new CopyActivityTypeProperties();
    private List<DatasetReference> inputs;
    private List<DatasetReference> outputs;
    private static final ClientLogger LOGGER = new ClientLogger(CopyActivity.class);

    @Override
    public String type() {
        return this.type;
    }

    CopyActivityTypeProperties innerTypeProperties() {
        return this.innerTypeProperties;
    }

    public List<DatasetReference> inputs() {
        return this.inputs;
    }

    public CopyActivity withInputs(List<DatasetReference> inputs) {
        this.inputs = inputs;
        return this;
    }

    public List<DatasetReference> outputs() {
        return this.outputs;
    }

    public CopyActivity withOutputs(List<DatasetReference> outputs) {
        this.outputs = outputs;
        return this;
    }

    @Override
    public CopyActivity withLinkedServiceName(LinkedServiceReference linkedServiceName) {
        super.withLinkedServiceName(linkedServiceName);
        return this;
    }

    @Override
    public CopyActivity withPolicy(ActivityPolicy policy) {
        super.withPolicy(policy);
        return this;
    }

    @Override
    public CopyActivity withName(String name) {
        super.withName(name);
        return this;
    }

    @Override
    public CopyActivity withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public CopyActivity withState(ActivityState state) {
        super.withState(state);
        return this;
    }

    @Override
    public CopyActivity withOnInactiveMarkAs(ActivityOnInactiveMarkAs onInactiveMarkAs) {
        super.withOnInactiveMarkAs(onInactiveMarkAs);
        return this;
    }

    @Override
    public CopyActivity withDependsOn(List<ActivityDependency> dependsOn) {
        super.withDependsOn((List)dependsOn);
        return this;
    }

    @Override
    public CopyActivity withUserProperties(List<UserProperty> userProperties) {
        super.withUserProperties((List)userProperties);
        return this;
    }

    public CopySource source() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().source();
    }

    public CopyActivity withSource(CopySource source) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSource(source);
        return this;
    }

    public CopySink sink() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().sink();
    }

    public CopyActivity withSink(CopySink sink) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSink(sink);
        return this;
    }

    public Object translator() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().translator();
    }

    public CopyActivity withTranslator(Object translator) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withTranslator(translator);
        return this;
    }

    public Object enableStaging() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableStaging();
    }

    public CopyActivity withEnableStaging(Object enableStaging) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableStaging(enableStaging);
        return this;
    }

    public StagingSettings stagingSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().stagingSettings();
    }

    public CopyActivity withStagingSettings(StagingSettings stagingSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withStagingSettings(stagingSettings);
        return this;
    }

    public Object parallelCopies() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().parallelCopies();
    }

    public CopyActivity withParallelCopies(Object parallelCopies) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withParallelCopies(parallelCopies);
        return this;
    }

    public Object dataIntegrationUnits() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().dataIntegrationUnits();
    }

    public CopyActivity withDataIntegrationUnits(Object dataIntegrationUnits) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withDataIntegrationUnits(dataIntegrationUnits);
        return this;
    }

    public Object enableSkipIncompatibleRow() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().enableSkipIncompatibleRow();
    }

    public CopyActivity withEnableSkipIncompatibleRow(Object enableSkipIncompatibleRow) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withEnableSkipIncompatibleRow(enableSkipIncompatibleRow);
        return this;
    }

    public RedirectIncompatibleRowSettings redirectIncompatibleRowSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().redirectIncompatibleRowSettings();
    }

    public CopyActivity withRedirectIncompatibleRowSettings(RedirectIncompatibleRowSettings redirectIncompatibleRowSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withRedirectIncompatibleRowSettings(redirectIncompatibleRowSettings);
        return this;
    }

    public LogStorageSettings logStorageSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logStorageSettings();
    }

    public CopyActivity withLogStorageSettings(LogStorageSettings logStorageSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withLogStorageSettings(logStorageSettings);
        return this;
    }

    public LogSettings logSettings() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().logSettings();
    }

    public CopyActivity withLogSettings(LogSettings logSettings) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withLogSettings(logSettings);
        return this;
    }

    public List<Object> preserveRules() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().preserveRules();
    }

    public CopyActivity withPreserveRules(List<Object> preserveRules) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withPreserveRules(preserveRules);
        return this;
    }

    public List<Object> preserve() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().preserve();
    }

    public CopyActivity withPreserve(List<Object> preserve) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withPreserve(preserve);
        return this;
    }

    public Object validateDataConsistency() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().validateDataConsistency();
    }

    public CopyActivity withValidateDataConsistency(Object validateDataConsistency) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withValidateDataConsistency(validateDataConsistency);
        return this;
    }

    public SkipErrorFile skipErrorFile() {
        return this.innerTypeProperties() == null ? null : this.innerTypeProperties().skipErrorFile();
    }

    public CopyActivity withSkipErrorFile(SkipErrorFile skipErrorFile) {
        if (this.innerTypeProperties() == null) {
            this.innerTypeProperties = new CopyActivityTypeProperties();
        }
        this.innerTypeProperties().withSkipErrorFile(skipErrorFile);
        return this;
    }

    @Override
    public void validate() {
        if (this.innerTypeProperties() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property innerTypeProperties in model CopyActivity"));
        }
        this.innerTypeProperties().validate();
        if (this.inputs() != null) {
            this.inputs().forEach(e -> e.validate());
        }
        if (this.outputs() != null) {
            this.outputs().forEach(e -> e.validate());
        }
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model CopyActivity"));
        }
        if (this.dependsOn() != null) {
            this.dependsOn().forEach(e -> e.validate());
        }
        if (this.userProperties() != null) {
            this.userProperties().forEach(e -> e.validate());
        }
        if (this.linkedServiceName() != null) {
            this.linkedServiceName().validate();
        }
        if (this.policy() != null) {
            this.policy().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeStringField("state", this.state() == null ? null : this.state().toString());
        jsonWriter.writeStringField("onInactiveMarkAs", this.onInactiveMarkAs() == null ? null : this.onInactiveMarkAs().toString());
        jsonWriter.writeArrayField("dependsOn", this.dependsOn(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("userProperties", this.userProperties(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("linkedServiceName", (JsonSerializable)this.linkedServiceName());
        jsonWriter.writeJsonField("policy", (JsonSerializable)this.policy());
        jsonWriter.writeJsonField("typeProperties", (JsonSerializable)this.innerTypeProperties);
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeArrayField("inputs", this.inputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("outputs", this.outputs, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.additionalProperties() != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties().entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CopyActivity fromJson(JsonReader jsonReader) throws IOException {
        return (CopyActivity)jsonReader.readObject(reader -> {
            CopyActivity deserializedCopyActivity = new CopyActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedCopyActivity.withName(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedCopyActivity.withDescription(reader.getString());
                    continue;
                }
                if ("state".equals(fieldName)) {
                    deserializedCopyActivity.withState(ActivityState.fromString(reader.getString()));
                    continue;
                }
                if ("onInactiveMarkAs".equals(fieldName)) {
                    deserializedCopyActivity.withOnInactiveMarkAs(ActivityOnInactiveMarkAs.fromString(reader.getString()));
                    continue;
                }
                if ("dependsOn".equals(fieldName)) {
                    List dependsOn = reader.readArray(reader1 -> ActivityDependency.fromJson(reader1));
                    deserializedCopyActivity.withDependsOn(dependsOn);
                    continue;
                }
                if ("userProperties".equals(fieldName)) {
                    List userProperties = reader.readArray(reader1 -> UserProperty.fromJson(reader1));
                    deserializedCopyActivity.withUserProperties(userProperties);
                    continue;
                }
                if ("linkedServiceName".equals(fieldName)) {
                    deserializedCopyActivity.withLinkedServiceName(LinkedServiceReference.fromJson(reader));
                    continue;
                }
                if ("policy".equals(fieldName)) {
                    deserializedCopyActivity.withPolicy(ActivityPolicy.fromJson(reader));
                    continue;
                }
                if ("typeProperties".equals(fieldName)) {
                    deserializedCopyActivity.innerTypeProperties = CopyActivityTypeProperties.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCopyActivity.type = reader.getString();
                    continue;
                }
                if ("inputs".equals(fieldName)) {
                    List inputs;
                    deserializedCopyActivity.inputs = inputs = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                if ("outputs".equals(fieldName)) {
                    List outputs;
                    deserializedCopyActivity.outputs = outputs = reader.readArray(reader1 -> DatasetReference.fromJson(reader1));
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCopyActivity.withAdditionalProperties(additionalProperties);
            return deserializedCopyActivity;
        });
    }
}

