/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.models.TarGZipReadSettings;
import com.azure.resourcemanager.datafactory.models.TarReadSettings;
import com.azure.resourcemanager.datafactory.models.ZipDeflateReadSettings;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class CompressionReadSettings
implements JsonSerializable<CompressionReadSettings> {
    private String type = "CompressionReadSettings";
    private Map<String, Object> additionalProperties;

    public String type() {
        return this.type;
    }

    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    public CompressionReadSettings withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public void validate() {
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static CompressionReadSettings fromJson(JsonReader jsonReader) throws IOException {
        return (CompressionReadSettings)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                CompressionReadSettings compressionReadSettings;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("ZipDeflateReadSettings".equals(discriminatorValue)) {
                    compressionReadSettings = ZipDeflateReadSettings.fromJson(readerToUse.reset());
                    return compressionReadSettings;
                }
                if ("TarReadSettings".equals(discriminatorValue)) {
                    compressionReadSettings = TarReadSettings.fromJson(readerToUse.reset());
                    return compressionReadSettings;
                }
                if ("TarGZipReadSettings".equals(discriminatorValue)) {
                    compressionReadSettings = TarGZipReadSettings.fromJson(readerToUse.reset());
                    return compressionReadSettings;
                }
                compressionReadSettings = CompressionReadSettings.fromJsonKnownDiscriminator(readerToUse.reset());
                return compressionReadSettings;
            }
        });
    }

    static CompressionReadSettings fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (CompressionReadSettings)jsonReader.readObject(reader -> {
            CompressionReadSettings deserializedCompressionReadSettings = new CompressionReadSettings();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedCompressionReadSettings.type = reader.getString();
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedCompressionReadSettings.additionalProperties = additionalProperties;
            return deserializedCompressionReadSettings;
        });
    }
}

