/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.datafactory.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.datafactory.fluent.models.ChangeDataCaptureResourceInner;
import java.io.IOException;
import java.util.List;

public final class ChangeDataCaptureListResponse
implements JsonSerializable<ChangeDataCaptureListResponse> {
    private List<ChangeDataCaptureResourceInner> value;
    private String nextLink;
    private static final ClientLogger LOGGER = new ClientLogger(ChangeDataCaptureListResponse.class);

    public List<ChangeDataCaptureResourceInner> value() {
        return this.value;
    }

    public ChangeDataCaptureListResponse withValue(List<ChangeDataCaptureResourceInner> value) {
        this.value = value;
        return this;
    }

    public String nextLink() {
        return this.nextLink;
    }

    public ChangeDataCaptureListResponse withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    public void validate() {
        if (this.value() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property value in model ChangeDataCaptureListResponse"));
        }
        this.value().forEach(e -> e.validate());
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    public static ChangeDataCaptureListResponse fromJson(JsonReader jsonReader) throws IOException {
        return (ChangeDataCaptureListResponse)jsonReader.readObject(reader -> {
            ChangeDataCaptureListResponse deserializedChangeDataCaptureListResponse = new ChangeDataCaptureListResponse();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("value".equals(fieldName)) {
                    List value;
                    deserializedChangeDataCaptureListResponse.value = value = reader.readArray(reader1 -> ChangeDataCaptureResourceInner.fromJson(reader1));
                    continue;
                }
                if ("nextLink".equals(fieldName)) {
                    deserializedChangeDataCaptureListResponse.nextLink = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedChangeDataCaptureListResponse;
        });
    }
}

